/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.internal;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.arquillian.rusheye.internal.Predicate;

public final class FilterCollection {
    private FilterCollection() {
    }

    public static <E> Collection<E> filter(Collection<E> collection, Predicate<E> predicate) {
        return new FilteredCollection<E>(collection, predicate);
    }

    private static class FilteredIterator<E>
    implements Iterator<E> {
        private Iterator<E> originalIterator;
        private Predicate<E> predicate;
        private E next;

        public FilteredIterator(Iterator<E> originalIterator, Predicate<E> predicate) {
            this.originalIterator = originalIterator;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.originalIterator.hasNext()) {
                this.next = this.originalIterator.next();
                if (this.predicate.apply(this.next)) {
                    return true;
                }
                this.next = null;
            }
            return false;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                E result = this.next;
                this.next = null;
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FilteredCollection<E>
    extends AbstractCollection<E> {
        private Collection<E> originalCollection;
        private Predicate<E> predicate;

        public FilteredCollection(Collection<E> originalCollection, Predicate<E> predicate) {
            this.originalCollection = originalCollection;
            this.predicate = predicate;
        }

        @Override
        public Iterator<E> iterator() {
            return new FilteredIterator<E>(this.originalCollection.iterator(), this.predicate);
        }

        @Override
        public int size() {
            int count = 0;
            for (E element : this) {
                ++count;
            }
            return count;
        }
    }
}

