/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.internal;

import org.arquillian.rusheye.exception.ConfigurationException;

public class Instantiator<T> {
    public T getInstance(String className) {
        try {
            return this.getInstanceClass(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(this.getMessage(className), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(this.getMessage(className), e);
        }
    }

    private Class<? extends T> getInstanceClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(this.getMessage(className), e);
        }
    }

    private String getMessage(String className) {
        return "Error when trying to create instance of class '" + className + "'";
    }
}

