/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.oneoff;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.arquillian.rusheye.oneoff.Log;
import org.arquillian.rusheye.retriever.mask.MaskFileRetriever;
import org.arquillian.rusheye.suite.HorizontalAlign;
import org.arquillian.rusheye.suite.Mask;
import org.arquillian.rusheye.suite.MaskType;
import org.arquillian.rusheye.suite.VerticalAlign;

public final class ImageUtils {
    private static MaskFileRetriever maskRetriever = new MaskFileRetriever();

    private ImageUtils() {
    }

    private static BufferedImage readImage(File directory, String fileName) throws IOException {
        File imageFile = new File(directory, fileName);
        return ImageIO.read(imageFile);
    }

    public static void writeImage(BufferedImage img, File directory, String fileName) throws IOException {
        ImageIO.write((RenderedImage)img, "png", new File(directory, fileName));
    }

    public static BufferedImage[] readSourceImages(File firstDirectory, File secondDirectory, String fileName) throws Exception {
        BufferedImage[] images = new BufferedImage[2];
        for (int i = 0; i < 2; ++i) {
            File directory = i == 0 ? firstDirectory : secondDirectory;
            try {
                images[i] = ImageUtils.readImage(directory, fileName);
                Log.logProcess("loading image %s", new File(directory, fileName).getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                throw new Exception("Cannot load or initialize image " + fileName);
            }
        }
        return images;
    }

    public static Set<Mask> readMaskImages(File maskDirectory) throws Exception {
        HashSet<Mask> masks = new HashSet<Mask>();
        for (String imageFileName : maskDirectory.list()) {
            File imageFile = new File(maskDirectory, imageFileName);
            Log.logSetup("read mask image %s", imageFileName);
            masks.add(ImageUtils.readMaskImage(imageFile));
        }
        return masks;
    }

    public static Mask readMaskImage(File maskFile) throws Exception {
        String maskFilename = maskFile.getName();
        Mask mask = new Mask();
        mask.setId(maskFile.getName());
        mask.setType(MaskType.SELECTIVE_ALPHA);
        mask.setSource(maskFile.toString());
        mask.setMaskRetriever(maskRetriever);
        mask.setHorizontalAlign(ImageUtils.resolveHorizontalOrientation(maskFilename));
        mask.setVerticalAlign(ImageUtils.resolveVerticalOrientation(maskFilename));
        mask.run();
        return mask;
    }

    private static HorizontalAlign resolveHorizontalOrientation(String fileName) {
        return ImageUtils.getFileFlags(fileName).contains("right") ? HorizontalAlign.RIGHT : HorizontalAlign.LEFT;
    }

    private static VerticalAlign resolveVerticalOrientation(String fileName) {
        return ImageUtils.getFileFlags(fileName).contains("bottom") ? VerticalAlign.BOTTOM : VerticalAlign.TOP;
    }

    private static List<String> getFileFlags(String fileName) {
        String[] parts = fileName.split("\\.");
        String[] flags = parts[1].split("-");
        return Arrays.asList(flags);
    }
}

