/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.oneoff;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import org.arquillian.rusheye.core.DefaultImageComparator;
import org.arquillian.rusheye.oneoff.ImageUtils;
import org.arquillian.rusheye.oneoff.Log;
import org.arquillian.rusheye.oneoff.OneOffConfiguration;
import org.arquillian.rusheye.oneoff.XmlWriter;
import org.arquillian.rusheye.suite.ComparisonResult;
import org.arquillian.rusheye.suite.Mask;

public class Main {
    private int errorsCounter = 0;
    private int differentImageCounter = 0;
    private int sameImageCounter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long t1 = System.currentTimeMillis();
        try {
            Log.logMain("started at %s", new Date().toString());
            new Main().run(args);
        }
        catch (Exception e) {
            try {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                long t2 = System.currentTimeMillis();
                Log.logStatistic("run duration:     %ds", (t2 - t1) / 1000L);
                Log.logMain("finished at %s", new Date().toString());
                throw throwable;
            }
            long t2 = System.currentTimeMillis();
            Log.logStatistic("run duration:     %ds", (t2 - t1) / 1000L);
            Log.logMain("finished at %s", new Date().toString());
        }
        long t2 = System.currentTimeMillis();
        Log.logStatistic("run duration:     %ds", (t2 - t1) / 1000L);
        Log.logMain("finished at %s", new Date().toString());
    }

    public void run(String[] args) throws Exception {
        OneOffConfiguration configuration = new OneOffConfiguration(args);
        Set<Mask> maskImages = ImageUtils.readMaskImages(configuration.getMaskDirectory());
        XmlWriter xmlWriter = new XmlWriter(configuration.getHtmlOutputDirectory());
        try {
            for (String imageFileName : configuration.getFirstSourceDirectory().list()) {
                this.testImage(configuration, maskImages, imageFileName, xmlWriter);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            xmlWriter.printXmlFooter();
            xmlWriter.close();
        }
        Log.logStatistic("same images:      %d", this.sameImageCounter);
        Log.logStatistic("different images: %d", this.differentImageCounter);
        Log.logStatistic("errors:           %d", this.errorsCounter);
    }

    private void testImage(OneOffConfiguration configuration, Set<Mask> maskImages, String imageFileName, XmlWriter xmlWriter) {
        Log.logProcess("testing image %s", imageFileName);
        try {
            BufferedImage[] sourceImages = ImageUtils.readSourceImages(configuration.getFirstSourceDirectory(), configuration.getSecondSourceDirectory(), imageFileName);
            ComparisonResult comparisonResult = new DefaultImageComparator().compare(sourceImages[0], sourceImages[1], configuration.getPerception(), maskImages);
            if (!comparisonResult.isEqualsImages()) {
                ++this.differentImageCounter;
                Log.logResult("DIFFER: %s", imageFileName);
                if (configuration.getDiffDirectory() != null) {
                    this.writeDiffImage(configuration, imageFileName, comparisonResult.getDiffImage());
                }
                if (configuration.getStructDiffDirectory() != null) {
                    this.writeStructDiffImage(configuration, imageFileName, sourceImages, comparisonResult.getDiffImage());
                }
            } else {
                ++this.sameImageCounter;
                Log.logResult("SAME: %s", imageFileName);
            }
            xmlWriter.printResultForOneImage(configuration, imageFileName, sourceImages, comparisonResult);
        }
        catch (Exception e) {
            ++this.errorsCounter;
            Log.logError("%s", e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    private void writeStructDiffImage(OneOffConfiguration configuration, String imageFileName, BufferedImage[] sourceImages, BufferedImage diffImage) throws IOException {
        String dirName = imageFileName.substring(0, imageFileName.lastIndexOf(46));
        File newDir = new File(configuration.getDiffDirectory(), dirName);
        Log.logProcess("creating directory %s", newDir.getAbsolutePath());
        newDir.mkdir();
        Log.logProcess("writing source and diff images to directory %s", dirName);
        ImageUtils.writeImage(sourceImages[0], newDir, "source1.png");
        ImageUtils.writeImage(sourceImages[1], newDir, "source2.png");
        ImageUtils.writeImage(diffImage, newDir, "diff.png");
    }

    private void writeDiffImage(OneOffConfiguration configuration, String imageFileName, BufferedImage diffImage) throws IOException {
        ImageUtils.writeImage(diffImage, configuration.getDiffDirectory(), imageFileName);
        Log.logProcess("writing diff image %s", imageFileName);
    }
}

