/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.oneoff;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.rusheye.oneoff.Log;
import org.arquillian.rusheye.suite.Configuration;

public class OneOffConfiguration
extends Configuration {
    private File firstSourceDirectory = null;
    private File secondSourceDirectory = null;
    private File diffDirectory = null;
    private File structDiffDirectory = null;
    private File maskDirectory = null;
    private File htmlOutputDirectory = null;

    public OneOffConfiguration(String[] args) {
        Log.logConfig("command line parameters: %d", args.length);
        this.readCommandLineParameters(args);
        this.printParameters();
    }

    private void printParameters() {
        Log.logConfig("first source directory:  %s", this.getAbsolutePath(this.firstSourceDirectory));
        Log.logConfig("second source directory: %s", this.getAbsolutePath(this.secondSourceDirectory));
        Log.logConfig("diffs directory:         %s", this.getAbsolutePath(this.diffDirectory));
        Log.logConfig("struct.diff directory:   %s", this.getAbsolutePath(this.structDiffDirectory));
        Log.logConfig("masks directory:         %s", this.getAbsolutePath(this.maskDirectory));
        Log.logConfig("html output directory:   %s", this.getAbsolutePath(this.htmlOutputDirectory));
    }

    private String getAbsolutePath(File directory) {
        return directory == null ? "not set" : directory.getAbsolutePath();
    }

    private void readCommandLineParameters(String[] args) {
        Map<String, String> options = this.resolveAllOptions(args);
        this.firstSourceDirectory = this.getPath(options, "s1");
        this.secondSourceDirectory = this.getPath(options, "s2");
        this.diffDirectory = this.getPath(options, "diffs");
        this.structDiffDirectory = this.getPath(options, "structdiffs");
        this.maskDirectory = this.getPath(options, "masks");
        this.htmlOutputDirectory = this.getPath(options, "htmlout");
    }

    private File getPath(Map<String, String> options, String optionName) {
        String fileName = options.get(optionName);
        if (fileName == null) {
            return null;
        }
        return new File(fileName);
    }

    private Map<String, String> resolveAllOptions(String[] args) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (String arg : args) {
            String[] splittedArg = arg.split("=");
            if (splittedArg.length == 2 && splittedArg[0].length() > 2) {
                Log.logConfig("found option %s", arg);
                options.put(splittedArg[0].substring(1), splittedArg[1]);
                continue;
            }
            Log.logWarning("unknown option %s", arg);
        }
        return options;
    }

    public File getFirstSourceDirectory() {
        return this.firstSourceDirectory;
    }

    public File getSecondSourceDirectory() {
        return this.secondSourceDirectory;
    }

    public File getDiffDirectory() {
        return this.diffDirectory;
    }

    public File getMaskDirectory() {
        return this.maskDirectory;
    }

    public File getHtmlOutputDirectory() {
        return this.htmlOutputDirectory;
    }

    public File getStructDiffDirectory() {
        return this.structDiffDirectory;
    }
}

