/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.oneoff;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arquillian.rusheye.oneoff.Log;
import org.arquillian.rusheye.oneoff.OneOffConfiguration;
import org.arquillian.rusheye.suite.ComparisonResult;

public class XmlWriter {
    private static final String XML_FILE_NAME = "results.xml";
    private BufferedWriter writer = null;

    public XmlWriter(File outputDirectory) throws IOException {
        this.writer = this.createXmlFile(outputDirectory);
        this.printXmlHeader();
    }

    private BufferedWriter createXmlFile(File outputDirectory) throws IOException {
        return outputDirectory == null ? null : new BufferedWriter(new FileWriter(new File(outputDirectory, XML_FILE_NAME)));
    }

    public void printXmlHeader() throws IOException {
        if (this.writer != null) {
            this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", new Object[0]);
            this.println("<visual-suite-result>", new Object[0]);
        }
    }

    public void printXmlFooter() throws IOException {
        if (this.writer != null) {
            this.println("</visual-suite-result>", new Object[0]);
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void print(String format, Object ... o) throws IOException {
        this.writer.write(String.format(format, o));
    }

    private void println(String format, Object ... o) throws IOException {
        this.print(format, o);
        this.writer.write("\n");
    }

    public void printResultForOneImage(OneOffConfiguration configuration, String imageFileName, BufferedImage[] sourceImages, ComparisonResult comparisonResult) throws IOException {
        String dirName = imageFileName.substring(0, imageFileName.lastIndexOf(46));
        this.printComparisonResult(comparisonResult, dirName);
        this.printPerception(comparisonResult);
        this.println("        </pattern>", new Object[0]);
        this.println("    </test>", new Object[0]);
        this.createAndFillResultDirectory(configuration, sourceImages, comparisonResult, dirName);
    }

    private void printComparisonResult(ComparisonResult comparisonResult, String dirName) throws IOException {
        boolean equalImages = comparisonResult.isEqualsImages();
        String result = equalImages ? "same" : "different";
        this.println("    <test id=\"%s\">", dirName);
        this.println("        <pattern id=\"%s\" result=\"%s\">", dirName, result);
        if (equalImages) {
            this.println("            <output/>", new Object[0]);
        } else {
            this.println("            <output>%s</output>", dirName);
        }
    }

    private void printPerception(ComparisonResult cr) throws IOException {
        this.println("            <perception>", new Object[0]);
        this.println("                <area width=\"%d\" height=\"%d\" />", cr.getArea().getWidth(), cr.getArea().getHeight());
        this.println("                <rectangle>", new Object[0]);
        this.println("                    <vertex x=\"%d\" y=\"%d\" />", cr.getRectangles().get((int)0).getMin().x, cr.getRectangles().get((int)0).getMin().y);
        this.println("                    <vertex x=\"%d\" y=\"%d\" />", cr.getRectangles().get((int)0).getMax().x, cr.getRectangles().get((int)0).getMax().y);
        this.println("                </rectangle>", new Object[0]);
        this.println("                <totalPixels>%d</totalPixels>", cr.getTotalPixels());
        this.println("                <maskedPixels>%d</maskedPixels>", cr.getMaskedPixels());
        this.println("                <perceptibleDifferentPixels>%d</perceptibleDifferentPixels>", cr.getPerceptibleDiffs());
        this.println("                <globalDifferentPixels>%d</globalDifferentPixels>", cr.getDifferentPixels());
        this.println("                <unperceptibleDifferentPixels>%d</unperceptibleDifferentPixels>", cr.getSmallDifferences());
        this.println("                <samePixels>%d</samePixels>", cr.getEqualPixels());
        this.println("            </perception>", new Object[0]);
    }

    private void createAndFillResultDirectory(OneOffConfiguration configuration, BufferedImage[] sourceImages, ComparisonResult comparisonResult, String dirName) throws IOException {
        File newDir = new File(configuration.getHtmlOutputDirectory(), dirName);
        Log.logProcess("creating directory %s", newDir.getAbsolutePath());
        newDir.mkdir();
        if (!comparisonResult.isEqualsImages()) {
            Log.logProcess("writing source and diff images to directory %s", dirName);
        } else {
            Log.logProcess("writing source image to directory %s", dirName);
        }
        this.createHtmlFile(newDir, comparisonResult);
    }

    private void createHtmlFile(File newDir, ComparisonResult cr) throws IOException {
        String line;
        String templateName = cr.isEqualsImages() ? "template_same_images.html" : "template_different_images.html";
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(newDir, "result.html")));
        BufferedReader template = new BufferedReader(new FileReader(templateName));
        while ((line = template.readLine()) != null) {
            writer.write(this.replacePlaceholders(cr, newDir, line));
        }
        template.close();
        writer.close();
    }

    private String replacePlaceholders(ComparisonResult cr, File newDir, String line) {
        StringBuffer out = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}", 2);
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            matcher.appendReplacement(out, this.getPlaceholderValue(cr, matcher.group(1)));
        }
        matcher.appendTail(out);
        return out.toString() + "\n";
    }

    private String getPlaceholderValue(ComparisonResult cr, String group) {
        try {
            Method method = cr.getClass().getDeclaredMethod("get" + group, null);
            return "" + method.invoke((Object)cr, (Object[])null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return group;
        }
    }
}

