/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.arquillian.rusheye.parser.DefaultConfiguration;
import org.arquillian.rusheye.suite.Configuration;
import org.arquillian.rusheye.suite.Mask;
import org.arquillian.rusheye.suite.Perception;

public class ConfigurationCompiler
extends Configuration {
    private static final Configuration DEFAULT_CONFIGURATION = new DefaultConfiguration();
    private Deque<Configuration> customConfigurations = new LinkedList<Configuration>();

    public ConfigurationCompiler() {
        this.customConfigurations.push(DEFAULT_CONFIGURATION);
    }

    public static <T extends Configuration> T wrap(final T configuration, final Configuration ... configurations) {
        Configuration proxy;
        ProxyFactory f = new ProxyFactory();
        f.setSuperclass(configuration.getClass());
        Class c = f.createClass();
        try {
            proxy = (Configuration)c.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        ((ProxyObject)((Object)proxy)).setHandler(new MethodHandler(){
            Object instance;
            ConfigurationCompiler configurationCompiler;
            {
                this.instance = configuration;
                this.configurationCompiler = new ConfigurationCompiler();
                for (Configuration conf : configurations) {
                    this.configurationCompiler.pushConfiguration(conf);
                }
                this.configurationCompiler.pushConfiguration(configuration);
            }

            @Override
            public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                Class<?> declaringClass = thisMethod.getDeclaringClass();
                if (declaringClass == Configuration.class) {
                    Method wrappedMethod = ConfigurationCompiler.class.getMethod(thisMethod.getName(), thisMethod.getParameterTypes());
                    return wrappedMethod.invoke((Object)this.configurationCompiler, args);
                }
                return thisMethod.invoke(this.instance, args);
            }
        });
        return (T)proxy;
    }

    public void pushConfiguration(Configuration configuration) {
        this.customConfigurations.push(configuration);
    }

    @Override
    public Perception getPerception() {
        return new PerceptionCompiler().getCompiledPerception();
    }

    @Override
    public void setPerception(Perception value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Mask> getMasks() {
        LinkedList<Mask> masks = new LinkedList<Mask>();
        for (Configuration configuration : this.customConfigurations) {
            if (configuration.getMasks() == null || configuration.getMasks().isEmpty()) continue;
            masks.addAll(configuration.getMasks());
        }
        return masks;
    }

    public class PerceptionCompiler
    implements MethodHandler {
        public Perception getCompiledPerception() {
            Perception perception;
            ProxyFactory f = new ProxyFactory();
            f.setSuperclass(Perception.class);
            Class c = f.createClass();
            try {
                perception = (Perception)c.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            ((ProxyObject)((Object)perception)).setHandler(this);
            return perception;
        }

        @Override
        public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            String methodName = thisMethod.getName();
            Class<?> declaringClass = thisMethod.getDeclaringClass();
            if (declaringClass == Perception.class) {
                if (methodName.startsWith("getGlobalDifferencePixelAmount") || methodName.startsWith("getGlobalDifferencePercentage")) {
                    Object result = proceed.invoke(self, args);
                    return result;
                }
                if (methodName.startsWith("get")) {
                    Object result = this.evaluate(thisMethod, args);
                    return result;
                }
            }
            throw new UnsupportedOperationException();
        }

        Object evaluate(Method thisMethod, Object[] args) throws Throwable {
            for (Configuration configuration : ConfigurationCompiler.this.customConfigurations) {
                Object result;
                Perception perception = configuration.getPerception();
                if (perception == null) continue;
                try {
                    result = thisMethod.invoke((Object)perception, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }
}

