/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.parser;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Set;
import org.arquillian.rusheye.listener.SuiteListener;
import org.arquillian.rusheye.parser.Context;
import org.arquillian.rusheye.suite.VisualSuite;

public class Handler {
    private Context context = new ListeningContext();
    private VisualSuite visualSuite;
    private Set<SuiteListener> parserListeners;

    public Handler(Set<SuiteListener> parserListeners) {
        this.parserListeners = parserListeners;
    }

    public VisualSuite getVisualSuite() {
        return this.visualSuite;
    }

    public void setVisualSuite(VisualSuite visualSuite) {
        this.visualSuite = visualSuite;
    }

    Context getContext() {
        return this.context;
    }

    private class ListeningContext
    extends Context
    implements InvocationHandler {
        SuiteListener wrappedListener;

        private ListeningContext() {
            this.wrappedListener = (SuiteListener)Proxy.newProxyInstance(Handler.this.getClass().getClassLoader(), new Class[]{SuiteListener.class}, (InvocationHandler)this);
        }

        @Override
        public SuiteListener invokeListeners() {
            return this.wrappedListener;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            LinkedHashSet listeners = new LinkedHashSet(Handler.this.parserListeners);
            for (SuiteListener listener : listeners) {
                Method wrappedMethod = listener.getClass().getMethod(method.getName(), method.getParameterTypes());
                try {
                    wrappedMethod.invoke((Object)listener, args);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException(e.getCause());
                }
                catch (Exception e) {
                    throw new IllegalStateException("unexpected invocation exception: " + e.getMessage(), e);
                }
            }
            return null;
        }
    }
}

