/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.parser;

import com.ctc.wstx.exc.WstxParsingException;
import com.ctc.wstx.exc.WstxValidationException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FileUtils;
import org.arquillian.rusheye.exception.ConfigurationException;
import org.arquillian.rusheye.exception.ConfigurationValidationException;
import org.arquillian.rusheye.exception.ParsingException;
import org.arquillian.rusheye.listener.SuiteListener;
import org.arquillian.rusheye.listener.SuiteListenerAdapter;
import org.arquillian.rusheye.parser.ConfigurationCompiler;
import org.arquillian.rusheye.parser.Handler;
import org.arquillian.rusheye.parser.RetriverInjector;
import org.arquillian.rusheye.parser.UniqueIdentityChecker;
import org.arquillian.rusheye.parser.UnmarshallerMultiListener;
import org.arquillian.rusheye.suite.GlobalConfiguration;
import org.arquillian.rusheye.suite.Mask;
import org.arquillian.rusheye.suite.Pattern;
import org.arquillian.rusheye.suite.Properties;
import org.arquillian.rusheye.suite.Test;
import org.arquillian.rusheye.suite.VisualSuite;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.ri.Stax2FilteredStreamReader;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;

public final class Parser {
    private Set<SuiteListener> listeners = new LinkedHashSet<SuiteListener>();
    private Handler handler = new Handler(this.listeners);
    private Properties properties;

    public Parser() {
        this.registerListener(new ParserListenerRegistrationListener());
    }

    public void parseResource(String resourceName) {
        InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
        this.parseStream(inputStream);
    }

    public void parseStream(InputStream inputStream) {
        try {
            int len;
            File tmp = File.createTempFile(Parser.class.getName(), ".tmp");
            BufferedInputStream in = new BufferedInputStream(inputStream);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.close();
            in.close();
            this.parseFileTempFile(tmp);
        }
        catch (IOException e) {
            throw new ParsingException(e);
        }
    }

    public void parseFile(File file) {
        this.parseFile(file, false);
    }

    public void parseFileTempFile(File file) {
        this.parseFile(file, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseFile(File file, boolean tmpfile) {
        VisualSuite visualSuite = null;
        try {
            XMLValidationSchemaFactory schemaFactory = XMLValidationSchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaURL = this.getClass().getClassLoader().getResource("org/arquillian/rusheye/visual-suite.xsd");
            XMLValidationSchema schema = schemaFactory.createSchema(schemaURL);
            XMLInputFactory2 factory = (XMLInputFactory2)XMLInputFactory.newInstance();
            StreamFilter filter = new StreamFilter(){

                @Override
                public boolean accept(XMLStreamReader reader) {
                    return reader.isStartElement();
                }
            };
            XMLStreamReader2 reader = factory.createXMLStreamReader(file);
            Stax2FilteredStreamReader filteredReader = new Stax2FilteredStreamReader(reader, filter);
            reader.validateAgainst(schema);
            JAXBContext ctx = JAXBContext.newInstance((String)VisualSuite.class.getPackage().getName());
            Unmarshaller um = ctx.createUnmarshaller();
            UnmarshallerMultiListener listener = new UnmarshallerMultiListener();
            um.setListener((Unmarshaller.Listener)listener);
            filteredReader.nextTag();
            visualSuite = new VisualSuite();
            this.handler.setVisualSuite(visualSuite);
            this.handler.getContext().invokeListeners().onSuiteStarted(visualSuite);
            listener.registerListener(new UniqueIdentityChecker(this.handler.getContext()));
            while (filteredReader.hasNext()) {
                try {
                    filteredReader.nextTag();
                    Object o = um.unmarshal((XMLStreamReader)reader);
                    if (o instanceof GlobalConfiguration) {
                        GlobalConfiguration globalConfiguration = (GlobalConfiguration)o;
                        this.handler.getContext().setCurrentConfiguration(globalConfiguration);
                        visualSuite.setGlobalConfiguration(globalConfiguration);
                        this.handler.getContext().invokeListeners().onConfigurationReady(visualSuite);
                        RetriverInjector retriverInjector = new RetriverInjector(this);
                        for (Mask mask : globalConfiguration.getMasks()) {
                            retriverInjector.afterUnmarshal(mask, null);
                        }
                        listener.registerListener(retriverInjector);
                    }
                    if (!(o instanceof Test)) continue;
                    Test test = (Test)o;
                    this.handler.getContext().setCurrentConfiguration(test);
                    this.handler.getContext().setCurrentTest(test);
                    for (Pattern pattern : test.getPatterns()) {
                        this.handler.getContext().invokeListeners().onPatternReady(test, pattern);
                    }
                    Test testWrapped = ConfigurationCompiler.wrap(test, visualSuite.getGlobalConfiguration());
                    this.handler.getContext().invokeListeners().onTestReady(testWrapped);
                }
                catch (WstxParsingException wstxParsingException) {}
            }
            if (visualSuite != null && this.handler.getContext() != null) {
                this.handler.getContext().invokeListeners().onSuiteReady(visualSuite);
            }
            if (!tmpfile) return;
        }
        catch (XMLStreamException e) {
            try {
                throw this.handleParsingException(e, e);
                catch (JAXBException e2) {
                    throw this.handleParsingException(e2, e2.getLinkedException());
                }
            }
            catch (Throwable throwable) {
                if (visualSuite != null && this.handler.getContext() != null) {
                    this.handler.getContext().invokeListeners().onSuiteReady(visualSuite);
                }
                if (!tmpfile) throw throwable;
                FileUtils.deleteQuietly(file);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly(file);
    }

    private RuntimeException handleParsingException(Throwable originalException, Throwable cause) {
        if (cause != null && cause instanceof WstxValidationException) {
            String message = cause.getMessage().replaceAll("\n", "");
            return new ConfigurationValidationException(message, cause);
        }
        return new ParsingException(originalException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(SuiteListener parserListener) {
        SuiteListener suiteListener = parserListener;
        synchronized (suiteListener) {
            if (this.listeners.contains(parserListener)) {
                return;
            }
            this.listeners.add(parserListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(SuiteListener parserListener) {
        Set<SuiteListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.contains(parserListener)) {
                this.listeners.remove(parserListener);
            }
        }
        throw new IllegalStateException("Given parser isn't registered");
    }

    Handler getHandler() {
        return this.handler;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private class ParserListenerRegistrationListener
    extends SuiteListenerAdapter {
        private ParserListenerRegistrationListener() {
        }

        @Override
        public void onConfigurationReady(VisualSuite visualSuite) {
            for (SuiteListener listener : visualSuite.getGlobalConfiguration().getListeners()) {
                if (Parser.this.properties != null) {
                    listener.setProperties(Parser.this.properties);
                }
                listener.onSuiteStarted(visualSuite);
                listener.onConfigurationReady(visualSuite);
                Parser.this.registerListener(listener);
            }
            if (Parser.this.listeners.size() == 1) {
                throw new ConfigurationException("No ParserListener was registered to process parsed tests");
            }
        }
    }
}

