/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.parser;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.bind.Unmarshaller;
import org.arquillian.rusheye.exception.ParsingException;
import org.arquillian.rusheye.parser.Parser;
import org.arquillian.rusheye.retriever.MaskRetriever;
import org.arquillian.rusheye.retriever.PatternRetriever;
import org.arquillian.rusheye.retriever.Retriever;
import org.arquillian.rusheye.retriever.SampleRetriever;
import org.arquillian.rusheye.suite.GlobalConfiguration;
import org.arquillian.rusheye.suite.Test;

class RetriverInjector
extends Unmarshaller.Listener {
    private Parser parser;
    private Map<Class<?>, List<Field>> fieldMap = new HashMap();

    RetriverInjector(Parser parser) {
        this.parser = parser;
    }

    public void afterUnmarshal(Object target, Object parent) {
        List<Object> fields;
        Class<?> targetClass = target.getClass();
        if (target instanceof Test) {
            Test test = (Test)target;
            this.afterUnmarshal(test.getSample(), test);
        }
        if (!this.fieldMap.containsKey(target.getClass())) {
            fields = new LinkedList();
            this.fieldMap.put(targetClass, fields);
            for (Field field : targetClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Resource.class)) continue;
                fields.add(field);
            }
        } else {
            fields = this.fieldMap.get(targetClass);
        }
        for (Field field : fields) {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            Retriever retriever = this.getRetriever(field.getType());
            try {
                field.set(target, retriever);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            if (accessible) continue;
            field.setAccessible(accessible);
        }
    }

    private Retriever getRetriever(Class<?> type) {
        GlobalConfiguration globalConfiguration = this.parser.getHandler().getVisualSuite().getGlobalConfiguration();
        if (type == MaskRetriever.class) {
            return globalConfiguration.getMaskRetriever();
        }
        if (type == PatternRetriever.class) {
            return globalConfiguration.getPatternRetriever();
        }
        if (type == SampleRetriever.class) {
            return globalConfiguration.getSampleRetriever();
        }
        throw new ParsingException();
    }
}

