/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.parser;

import javax.xml.bind.Unmarshaller;
import org.arquillian.rusheye.exception.ConfigurationValidationException;
import org.arquillian.rusheye.parser.Context;
import org.arquillian.rusheye.suite.Mask;
import org.arquillian.rusheye.suite.Pattern;
import org.arquillian.rusheye.suite.Test;

public class UniqueIdentityChecker
extends Unmarshaller.Listener {
    private Context context;

    UniqueIdentityChecker(Context context) {
        this.context = context;
    }

    public void afterUnmarshal(Object target, Object parent) {
        if (target instanceof Test) {
            Test test = (Test)target;
            if (this.context.getTestNames().contains(test.getName())) {
                throw new ConfigurationValidationException("test's \"name\" attribute have to be unique across suite");
            }
            this.context.getTestNames().add(test.getName());
        }
        if (target instanceof Pattern) {
            Pattern pattern = (Pattern)target;
            if (this.context.getPatternNames().contains(pattern.getName())) {
                throw new ConfigurationValidationException("pattern's \"name\" attribute have to be unique across suite");
            }
            this.context.getPatternNames().add(pattern.getName());
        }
        if (target instanceof Mask) {
            Mask mask = (Mask)target;
            if (this.context.getMaskIds().contains(mask.getId())) {
                throw new ConfigurationValidationException("mask's \"id\" attribute have to be unique across suite");
            }
            this.context.getMaskIds().add(mask.getId());
        }
    }
}

