/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.parser.listener;

import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import org.arquillian.rusheye.comparison.ImageComparator;
import org.arquillian.rusheye.core.DefaultImageComparator;
import org.arquillian.rusheye.internal.Instantiator;
import org.arquillian.rusheye.listener.SuiteListener;
import org.arquillian.rusheye.result.ResultCollector;
import org.arquillian.rusheye.suite.ComparisonResult;
import org.arquillian.rusheye.suite.Configuration;
import org.arquillian.rusheye.suite.Mask;
import org.arquillian.rusheye.suite.Pattern;
import org.arquillian.rusheye.suite.Properties;
import org.arquillian.rusheye.suite.Sample;
import org.arquillian.rusheye.suite.Test;
import org.arquillian.rusheye.suite.VisualSuite;

public class CompareListener
implements SuiteListener {
    Properties properties = new Properties();
    ImageComparator imageComparator = new DefaultImageComparator();
    VisualSuite visualSuite;
    ResultCollector resultCollector;

    @Override
    public void setProperties(Properties properties) {
        this.properties.include(properties);
    }

    @Override
    public void onSuiteStarted(VisualSuite visualSuite) {
        this.visualSuite = visualSuite;
        String resultListenerClass = (String)this.properties.getProperty("result-collector");
        this.resultCollector = (ResultCollector)new Instantiator().getInstance(resultListenerClass);
        this.resultCollector.setProperties(this.properties);
        this.resultCollector.onSuiteStarted(visualSuite);
    }

    @Override
    public void onConfigurationReady(VisualSuite visualSuite) {
        this.resultCollector.onConfigurationReady(visualSuite);
    }

    @Override
    public void onSuiteReady(VisualSuite visualSuite) {
        this.resultCollector.onSuiteReady(visualSuite);
        this.resultCollector.onSuiteCompleted(visualSuite);
    }

    @Override
    public void onPatternReady(Configuration configuration, Pattern pattern) {
        pattern.include(this.properties);
        pattern.run();
        this.resultCollector.onPatternReady(configuration, pattern);
        this.resultCollector.onPatternStarted(pattern);
    }

    @Override
    public void onTestReady(Test test) {
        this.resultCollector.onTestReady(test);
        this.resultCollector.onTestStarted(test);
        this.resultCollector.onSampleStarted(test);
        Sample sample = test.getSample();
        sample.include(this.properties);
        BufferedImage sampleImage = this.getSampleImage(sample);
        for (Mask mask : test.getMasks()) {
            mask.include(this.properties);
        }
        this.resultCollector.onSampleLoaded(test);
        for (Pattern pattern : test.getPatterns()) {
            BufferedImage patternImage = this.getPatternImage(pattern);
            this.resultCollector.onPatternLoaded(test, pattern);
            ComparisonResult comparisonResult = this.imageComparator.compare(patternImage, sampleImage, test.getPerception(), test.getSelectiveAlphaMasks());
            this.resultCollector.onPatternCompleted(test, pattern, comparisonResult);
        }
        this.resultCollector.onTestCompleted(test);
    }

    private BufferedImage getSampleImage(Sample sample) {
        sample.run();
        try {
            return sample.get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private BufferedImage getPatternImage(Pattern pattern) {
        try {
            return pattern.get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }
}

