/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.result;

import java.math.BigDecimal;
import org.arquillian.rusheye.suite.ComparisonResult;
import org.arquillian.rusheye.suite.Perception;
import org.arquillian.rusheye.suite.ResultConclusion;

public class ResultEvaluator {
    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100);

    public ResultConclusion evaluate(Perception perception, ComparisonResult comparisonResult) {
        if (comparisonResult.isEqualsImages()) {
            return ResultConclusion.SAME;
        }
        if (perception.getGlobalDifferencePercentage() != null) {
            BigDecimal totalPixels = new BigDecimal(comparisonResult.getTotalPixels());
            BigDecimal differentPixels = new BigDecimal(comparisonResult.getDifferentPixels());
            BigDecimal ratio = comparisonResult.getTotalPixels() != 0 ? differentPixels.multiply(ONE_HUNDRED).divide(totalPixels) : BigDecimal.ZERO;
            int result = ratio.compareTo(new BigDecimal(perception.getGlobalDifferencePercentage().shortValue()));
            if (result <= 0) {
                return ResultConclusion.PERCEPTUALLY_SAME;
            }
        } else if (perception.getGlobalDifferencePixelAmount() != null) {
            if ((long)comparisonResult.getDifferentPixels() <= perception.getGlobalDifferencePixelAmount()) {
                return ResultConclusion.PERCEPTUALLY_SAME;
            }
        } else {
            return ResultConclusion.ERROR;
        }
        return ResultConclusion.DIFFER;
    }
}

