/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.result.collector;

import org.arquillian.rusheye.internal.Instantiator;
import org.arquillian.rusheye.result.ResultCollectorAdapter;
import org.arquillian.rusheye.result.ResultEvaluator;
import org.arquillian.rusheye.result.ResultStatistics;
import org.arquillian.rusheye.result.ResultStorage;
import org.arquillian.rusheye.result.writer.ResultWriter;
import org.arquillian.rusheye.suite.ComparisonResult;
import org.arquillian.rusheye.suite.Pattern;
import org.arquillian.rusheye.suite.Properties;
import org.arquillian.rusheye.suite.ResultConclusion;
import org.arquillian.rusheye.suite.Test;
import org.arquillian.rusheye.suite.VisualSuite;

public class ResultCollectorImpl
extends ResultCollectorAdapter {
    Properties properties;
    ResultStorage storage;
    ResultEvaluator evaluator;
    ResultWriter writer;
    ResultStatistics statistics;

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void onConfigurationReady(VisualSuite visualSuite) {
        String storageClass = (String)this.properties.getProperty("result-storage");
        this.storage = (ResultStorage)new Instantiator().getInstance(storageClass);
        this.storage.setProperties(this.properties);
        String writerClass = (String)this.properties.getProperty("result-writer");
        this.writer = (ResultWriter)new Instantiator().getInstance(writerClass);
        this.writer.setProperties(this.properties);
        String statisticsClass = (String)this.properties.getProperty("result-statistics");
        this.statistics = (ResultStatistics)new Instantiator().getInstance(statisticsClass);
        this.statistics.setProperties(this.properties);
        this.evaluator = new ResultEvaluator();
    }

    @Override
    public void onPatternCompleted(Test test, Pattern pattern, ComparisonResult comparisonResult) {
        ResultConclusion conclusion = this.evaluator.evaluate(test.getPerception(), comparisonResult);
        pattern.setConclusion(conclusion);
        if (conclusion == ResultConclusion.DIFFER || conclusion == ResultConclusion.PERCEPTUALLY_SAME) {
            String location = this.storage.store(test, pattern, comparisonResult.getDiffImage());
            pattern.setOutput(location);
        }
        if (comparisonResult.getDiffImage() != null) {
            comparisonResult.getDiffImage().flush();
        }
        pattern.setComparisonResult(comparisonResult);
        this.statistics.onPatternCompleted(pattern);
    }

    @Override
    public void onTestCompleted(Test test) {
        this.writer.write(test);
        this.statistics.onTestCompleted(test);
    }

    @Override
    public void onSuiteCompleted(VisualSuite visualSuite) {
        this.writer.close();
        this.statistics.onSuiteCompleted();
        this.storage.end();
    }
}

