/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.result.statistics;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.arquillian.rusheye.result.ResultStatistics;
import org.arquillian.rusheye.suite.Pattern;
import org.arquillian.rusheye.suite.Properties;
import org.arquillian.rusheye.suite.ResultConclusion;
import org.arquillian.rusheye.suite.Test;

public class OverallStatistics
implements ResultStatistics {
    PrintWriter printerWriter;
    Map<ResultConclusion, AtomicLong> conclusionStatistics = new LinkedHashMap<ResultConclusion, AtomicLong>();

    public OverallStatistics() {
        for (ResultConclusion conclusion : ResultConclusion.values()) {
            this.conclusionStatistics.put(conclusion, new AtomicLong(0L));
        }
    }

    @Override
    public void setProperties(Properties properties) {
        Writer writer = (Writer)properties.getProperty("overall-statistics-output");
        if (writer == null) {
            writer = new OutputStreamWriter(System.out);
        }
        this.printerWriter = new PrintWriter(writer);
    }

    @Override
    public void onPatternCompleted(Pattern pattern) {
        if (pattern.getConclusion() == ResultConclusion.ERROR) {
            this.addConclusion(ResultConclusion.ERROR);
        }
    }

    @Override
    public void onTestCompleted(Test test) {
        ResultConclusion bestConclusion = ResultConclusion.ERROR;
        for (Pattern pattern : test.getPatterns()) {
            if (pattern.getConclusion().ordinal() >= ResultConclusion.ERROR.ordinal()) continue;
            bestConclusion = pattern.getConclusion();
        }
        if (bestConclusion != ResultConclusion.ERROR) {
            this.addConclusion(bestConclusion);
        }
        this.printerWriter.println("[ " + (Object)((Object)bestConclusion) + " ] " + test.getName());
        this.printerWriter.flush();
    }

    @Override
    public void onSuiteCompleted() {
        this.printerWriter.println();
        this.printerWriter.println("=====================");
        this.printerWriter.println("  Overall Statistics:");
        for (Map.Entry<ResultConclusion, AtomicLong> entry : this.conclusionStatistics.entrySet()) {
            long count = entry.getValue().get();
            if (count <= 0L) continue;
            this.printerWriter.println("  " + (Object)((Object)entry.getKey()) + ": " + count);
        }
        this.printerWriter.println("=====================");
        this.printerWriter.flush();
    }

    private void addConclusion(ResultConclusion conclusion) {
        this.conclusionStatistics.get((Object)conclusion).incrementAndGet();
    }
}

