/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.result.storage;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.arquillian.rusheye.result.ResultStorage;
import org.arquillian.rusheye.suite.Pattern;
import org.arquillian.rusheye.suite.Properties;
import org.arquillian.rusheye.suite.Test;

public class FileStorage
implements ResultStorage {
    private Properties properties;

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String store(Test test, Pattern pattern, BufferedImage differenceImage) {
        File directory = new File((String)this.properties.getProperty("file-storage-directory"));
        File addition = new File(test.getName() + "." + pattern.getName() + ".png");
        File file = new File(directory, addition.getPath());
        try {
            FileUtils.forceMkdir(file.getParentFile());
            ImageIO.write((RenderedImage)differenceImage, "PNG", file);
        }
        catch (IOException e) {
            throw new IllegalStateException("was not able to write difference image");
        }
        return addition.getPath();
    }

    @Override
    public void end() {
    }
}

