/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.result.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.arquillian.rusheye.result.writer.PrettyXMLStreamWriter;
import org.arquillian.rusheye.result.writer.ResultWriter;
import org.arquillian.rusheye.result.writer.WriterContext;
import org.arquillian.rusheye.suite.Properties;
import org.arquillian.rusheye.suite.Test;
import org.arquillian.rusheye.suite.annotations.VisualSuiteResult;
import org.arquillian.rusheye.suite.utils.NullingProxy;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;

public abstract class XmlResultWriter
implements ResultWriter {
    protected Properties properties;
    private XMLStreamWriter writer;
    private OutputStream out;
    private Marshaller marshaller;
    private boolean writerFailedToInitialize = false;
    private boolean writerFailed = false;
    private boolean writtenStartDocument = false;

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public boolean write(Test test) {
        if (!this.tryInitializeWriter()) {
            return false;
        }
        return this.writeSafely(new WriterContext(test));
    }

    private boolean writeSafely(WriterContext context) {
        this.tryWriteStartDocument();
        this.tryWriteTest(context);
        return !this.writerFailed;
    }

    private void tryWriteStartDocument() {
        if (!this.writerFailed && !this.writtenStartDocument) {
            try {
                this.writer.writeStartDocument("UTF-8", "1.0");
                this.writer.setDefaultNamespace("http://www.jboss.org/rusheye/visual-suite-result");
                this.writer.writeStartElement("http://www.jboss.org/rusheye/visual-suite-result", "visual-suite-result");
                this.writer.writeDefaultNamespace("http://www.jboss.org/rusheye/visual-suite-result");
                this.writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this.writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.jboss.org/rusheye/visual-suite-result http://www.jboss.org/schema/arquillian/rusheye/visual-suite-result.xsd");
                this.writtenStartDocument = true;
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                this.writerFailed = true;
            }
        }
    }

    private void tryWriteTest(WriterContext context) {
        if (!this.writerFailed) {
            try {
                Test test = context.getTest();
                test = NullingProxy.handle(test, VisualSuiteResult.class);
                this.marshaller.marshal((Object)test, this.writer);
                this.writer.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.writerFailed = true;
            }
        }
    }

    private boolean tryInitializeWriter() {
        if (!this.writerFailedToInitialize && this.out == null && this.writer == null) {
            try {
                this.out = this.openOutputStream();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.writerFailedToInitialize = true;
            }
            try {
                this.writer = this.createXMLStreamWriter();
                this.marshaller = this.createMarshaller();
                this.marshaller.setProperty("jaxb.fragment", (Object)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.writerFailedToInitialize = true;
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return !this.writerFailedToInitialize;
    }

    private XMLStreamWriter createXMLStreamWriter() throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter2 writer = (XMLStreamWriter2)factory.createXMLStreamWriter(this.out);
        writer.validateAgainst(this.createXMLValidationSchema());
        return PrettyXMLStreamWriter.pretty(writer);
    }

    private Marshaller createMarshaller() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"org.arquillian.rusheye.suite");
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        return marshaller;
    }

    private XMLValidationSchema createXMLValidationSchema() throws XMLStreamException {
        XMLValidationSchemaFactory schemaFactory = XMLValidationSchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaURL = this.getClass().getClassLoader().getResource("org/arquillian/rusheye/visual-suite-result.xsd");
        XMLValidationSchema schema = schemaFactory.createSchema(schemaURL);
        return schema;
    }

    protected abstract OutputStream openOutputStream() throws Exception;

    protected abstract void closeOutputStream() throws Exception;

    @Override
    public void close() {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.writeEndElement();
                this.writer.close();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        try {
            this.closeOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

