/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.retriever;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.arquillian.rusheye.exception.RetrieverException;
import org.arquillian.rusheye.retriever.AbstractRetriever;
import org.arquillian.rusheye.retriever.MaskRetriever;
import org.arquillian.rusheye.retriever.PatternRetriever;
import org.arquillian.rusheye.suite.Properties;

public class ResourceRetriever
extends AbstractRetriever
implements PatternRetriever,
MaskRetriever {
    @Override
    public BufferedImage retrieve(String source, Properties localProperties) throws RetrieverException {
        BufferedImage bufferedImage;
        URL resourceURL = this.getClass().getClassLoader().getResource(source);
        if (resourceURL == null) {
            throw new RetrieverException(this.getClass().getSimpleName() + " wasn't able to retrieve image source '" + source + "' - given source doesn't exist");
        }
        try {
            bufferedImage = ImageIO.read(resourceURL);
        }
        catch (IOException e) {
            throw new RetrieverException(this.getClass().getSimpleName() + " wasn't able to retrieve image source '" + source + "' from resourceURL '" + resourceURL + "'", e);
        }
        return bufferedImage;
    }
}

