/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.retriever.sample;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.arquillian.rusheye.exception.NoSuchSampleException;
import org.arquillian.rusheye.exception.RetrieverException;
import org.arquillian.rusheye.retriever.AbstractRetriever;
import org.arquillian.rusheye.retriever.SampleRetriever;
import org.arquillian.rusheye.suite.Properties;

public abstract class AbstractSampleRetriever
extends AbstractRetriever
implements SampleRetriever {
    private SortedSet<String> allSources = null;
    private SortedSet<String> unretrievedSources = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage retrieve(String source, Properties localProperties) throws RetrieverException {
        Properties mergedProperties = this.mergeProperties(localProperties);
        if (this.allSources == null) {
            AbstractSampleRetriever abstractSampleRetriever = this;
            synchronized (abstractSampleRetriever) {
                this.allSources = new TreeSet<String>(this.getAllSources(mergedProperties));
                this.unretrievedSources = new TreeSet<String>(this.allSources);
            }
        }
        int retries = mergedProperties.getProperty("load-source-retries", 1, Integer.class);
        if (!this.allSources.contains(source)) {
            throw new NoSuchSampleException("source '" + source + "' wasn't found when listing all of available samples");
        }
        for (int i = 0; i < retries; ++i) {
            try {
                return this.loadSource(source, mergedProperties);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new RetrieverException("can't load the source '" + source + "'");
    }

    protected abstract Set<String> getAllSources(Properties var1) throws RetrieverException;

    protected abstract BufferedImage loadSource(String var1, Properties var2) throws RetrieverException;

    @Override
    public Set<String> getNewSources() {
        return Collections.unmodifiableSet(this.unretrievedSources);
    }
}

