/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.retriever.sample;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.arquillian.rusheye.exception.RetrieverException;
import org.arquillian.rusheye.retriever.sample.AbstractSampleRetriever;
import org.arquillian.rusheye.suite.Properties;

public class FileSampleRetriever
extends AbstractSampleRetriever {
    private String commonExtension;

    @Override
    protected Set<String> getAllSources(Properties properties) throws RetrieverException {
        File samplesDirectory = FileSampleRetriever.getSamplesDirectory(properties);
        TreeSet<String> sources = new TreeSet<String>();
        for (String sourceFilename : samplesDirectory.list()) {
            String extension = StringUtils.substringAfterLast(sourceFilename, ".");
            this.checkExtensionUniformity(extension, sourceFilename);
            String sourceName = StringUtils.substringBeforeLast(sourceFilename, ".");
            sources.add(sourceName);
        }
        return Collections.unmodifiableSet(sources);
    }

    @Override
    protected BufferedImage loadSource(String source, Properties properties) throws RetrieverException {
        File samplesDirectory = FileSampleRetriever.getSamplesDirectory(properties);
        String filename = source + "." + this.commonExtension;
        try {
            return ImageIO.read(new File(samplesDirectory, filename));
        }
        catch (IOException e) {
            throw new RetrieverException("can't load sample from source '" + source + "'", e);
        }
    }

    private void checkExtensionUniformity(String extension, String sourceFilename) throws RetrieverException {
        if (this.commonExtension == null) {
            this.commonExtension = extension;
        } else if (!this.commonExtension.equals(extension)) {
            throw new RetrieverException("This retriever found the two certain file extensions (" + this.commonExtension + ", " + extension + ") when loading image '" + sourceFilename + "', it is against the contract of the extension uniformity of all loaded samples");
        }
    }

    private static File getSamplesDirectory(Properties properties) {
        File samplesDirectory = properties.getProperty("samples-directory", File.class);
        if (samplesDirectory == null) {
            throw new IllegalArgumentException("the 'samples-directory' property have to be defined in order to load list of available sources");
        }
        return samplesDirectory;
    }
}

