/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.retriever.sample;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import org.arquillian.rusheye.exception.RetrieverException;
import org.arquillian.rusheye.retriever.AbstractRetriever;
import org.arquillian.rusheye.retriever.ResourceRetriever;
import org.arquillian.rusheye.retriever.SampleRetriever;
import org.arquillian.rusheye.suite.Properties;

public class ResourceSampleRetriever
extends AbstractRetriever
implements SampleRetriever {
    public static final String RESOURCES_LOCATION = "resources-location";
    public static final String RESOURCE_EXTENSION = "resource-suffix";

    @Override
    public BufferedImage retrieve(String source, Properties localProperties) throws RetrieverException {
        BufferedImage bufferedImage;
        Properties properties = this.mergeProperties(localProperties);
        File resourcesLocation = properties.getProperty(RESOURCES_LOCATION, File.class);
        String resourceExtension = properties.getProperty(RESOURCE_EXTENSION, String.class);
        if (resourcesLocation == null) {
            throw new IllegalStateException("sample retriever property 'resources-location' have to be set in order to obtain resources");
        }
        if (resourceExtension == null) {
            throw new IllegalStateException("sample retriever property 'resource-suffix' have to be set in order to obtain resources");
        }
        File sourceFile = new File(resourcesLocation, source + resourceExtension);
        URL resourceURL = this.getClass().getClassLoader().getResource(sourceFile.getPath());
        try {
            bufferedImage = ImageIO.read(resourceURL);
        }
        catch (IOException e) {
            throw new RetrieverException(ResourceRetriever.class.getSimpleName() + " wasn't able to retrieve image from resourceURL '" + resourceURL + "'", e);
        }
        return bufferedImage;
    }

    @Override
    public Set<String> getNewSources() {
        return new HashSet<String>();
    }
}

