/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.suite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.arquillian.rusheye.internal.FilterCollection;
import org.arquillian.rusheye.internal.Predicate;
import org.arquillian.rusheye.suite.GlobalConfiguration;
import org.arquillian.rusheye.suite.Mask;
import org.arquillian.rusheye.suite.MaskType;
import org.arquillian.rusheye.suite.Perception;
import org.arquillian.rusheye.suite.Test;
import org.arquillian.rusheye.suite.annotations.Nullify;
import org.arquillian.rusheye.suite.annotations.VisualSuiteResult;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(name="Configuration", propOrder={"perception", "masks"})
@XmlSeeAlso(value={GlobalConfiguration.class, Test.class})
public abstract class Configuration {
    protected Perception perception;
    protected List<Mask> masks;

    @Nullify(value={VisualSuiteResult.class})
    public Perception getPerception() {
        return this.perception;
    }

    public void setPerception(Perception value) {
        this.perception = value;
    }

    @XmlElement(name="mask")
    @Nullify(value={VisualSuiteResult.class})
    public List<Mask> getMasks() {
        if (this.masks == null) {
            this.masks = new ArrayList<Mask>();
        }
        return this.masks;
    }

    @XmlTransient
    public final Collection<Mask> getSelectiveAlphaMasks() {
        return FilterCollection.filter(this.getMasks(), new Predicate<Mask>(){

            @Override
            public boolean apply(Mask mask) {
                return MaskType.SELECTIVE_ALPHA.equals((Object)mask.getType());
            }
        });
    }

    @XmlTransient
    public final Collection<Mask> getIgnoreBitmapMasks() {
        return FilterCollection.filter(this.getMasks(), new Predicate<Mask>(){

            @Override
            public boolean apply(Mask mask) {
                return MaskType.IGNORE_BITMAP.equals((Object)mask.getType());
            }
        });
    }
}

