/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.suite;

import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.arquillian.rusheye.retriever.MaskRetriever;
import org.arquillian.rusheye.suite.HorizontalAlign;
import org.arquillian.rusheye.suite.ImageSource;
import org.arquillian.rusheye.suite.MaskType;
import org.arquillian.rusheye.suite.VerticalAlign;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(name="Mask")
public class Mask
extends ImageSource {
    private static final int ALPHA_MASK = -16777216;
    protected String id;
    protected MaskType type;
    protected VerticalAlign verticalAlign;
    protected HorizontalAlign horizontalAlign;
    @Resource
    @XmlTransient
    private MaskRetriever maskRetriever;

    @XmlAttribute(required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="Name")
    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @XmlAttribute(required=true)
    public MaskType getType() {
        return this.type;
    }

    public void setType(MaskType value) {
        this.type = value;
    }

    @XmlAttribute(name="vertical-align")
    public VerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(VerticalAlign value) {
        this.verticalAlign = value;
    }

    @XmlAttribute(name="horizontal-align")
    public HorizontalAlign getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(HorizontalAlign value) {
        this.horizontalAlign = value;
    }

    @Override
    public BufferedImage retrieve() throws Exception {
        return this.maskRetriever.retrieve(this.source, this);
    }

    private BufferedImage getMaskImage() {
        this.run();
        try {
            return this.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPixelMasked(BufferedImage pattern, int x, int y) {
        int maskY;
        BufferedImage maskImage = this.getMaskImage();
        int patternWidth = pattern.getWidth();
        int patternHeight = pattern.getHeight();
        int maskWidth = maskImage.getWidth();
        int maskHeight = maskImage.getHeight();
        int maskX = this.horizontalAlign == HorizontalAlign.LEFT ? x : x - (patternWidth - maskWidth);
        int n = maskY = this.verticalAlign == VerticalAlign.TOP ? y : y - (patternHeight - maskHeight);
        if (maskX < 0 || maskX >= maskWidth || maskY < 0 || maskY >= maskHeight) {
            return false;
        }
        return (maskImage.getRGB(maskX, maskY) & 0xFF000000) != 0;
    }

    public void setMaskRetriever(MaskRetriever maskRetriever) {
        this.maskRetriever = maskRetriever;
    }
}

