/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.suite;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(name="Perception", propOrder={"onePixelTreshold", "globalDifferenceTreshold", "globalDifferenceAmount"})
public class Perception {
    private static final Number NOT_THIS_TYPE = new Double("0");
    protected Float onePixelTreshold;
    protected Float globalDifferenceTreshold;
    protected String globalDifferenceAmount;

    @XmlElement(name="one-pixel-treshold")
    public Float getOnePixelTreshold() {
        return this.onePixelTreshold;
    }

    public void setOnePixelTreshold(Float value) {
        this.onePixelTreshold = value;
    }

    @XmlElement(name="global-difference-treshold")
    public Float getGlobalDifferenceTreshold() {
        return this.globalDifferenceTreshold;
    }

    public void setGlobalDifferenceTreshold(Float value) {
        this.globalDifferenceTreshold = value;
    }

    @XmlElement(name="global-difference-pixel-amount")
    public String getGlobalDifferenceAmount() {
        return this.globalDifferenceAmount;
    }

    public void setGlobalDifferenceAmount(String value) {
        this.globalDifferenceAmount = value;
    }

    @XmlTransient
    public Long getGlobalDifferencePixelAmount() {
        Number number = this.getGlobalDifferenceAmount(AmountType.PIXEL);
        return number != NOT_THIS_TYPE ? Long.valueOf(number.longValue()) : null;
    }

    public void setGlobalDifferencePixelAmount(long globalDifferencePixelAmount) {
        this.globalDifferenceAmount = Long.toString(globalDifferencePixelAmount) + "px";
    }

    @XmlTransient
    public Short getGlobalDifferencePercentage() {
        Number number = this.getGlobalDifferenceAmount(AmountType.PERCENTAGE);
        return number != NOT_THIS_TYPE ? Short.valueOf(number.shortValue()) : null;
    }

    public void setGlobalDifferencePercentage(short globalDifferencePercentage) {
        this.globalDifferenceAmount = Short.valueOf(globalDifferencePercentage) + "%";
    }

    public Number getGlobalDifferenceAmount(AmountType amountType) {
        String amount = this.getGlobalDifferenceAmount();
        if (amount == null) {
            return null;
        }
        Matcher matcher = amountType.getPattern().matcher(amount);
        if (matcher.lookingAt()) {
            return amountType.parseAmount(matcher.group(1));
        }
        return NOT_THIS_TYPE;
    }

    public AmountType getGlobalDifferenceAmountType() {
        String amount = this.getGlobalDifferenceAmount();
        for (AmountType type : AmountType.values()) {
            if (!type.getPattern().matcher(amount).matches()) continue;
            return type;
        }
        throw new IllegalStateException("The amount needs to be one of AmountType");
    }

    public static enum AmountType {
        PERCENTAGE("([0-9]{1,2}|100)%"),
        PIXEL("^([0-9]+)px$");

        private Pattern pattern;

        private AmountType(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        Pattern getPattern() {
            return this.pattern;
        }

        Number parseAmount(String string) {
            if (this == PERCENTAGE) {
                return Short.valueOf(string);
            }
            return Long.valueOf(string);
        }
    }
}

