/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.suite;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.arquillian.rusheye.internal.FilterCollection;
import org.arquillian.rusheye.internal.Predicate;
import org.arquillian.rusheye.internal.SimpleElement;
import org.arquillian.rusheye.suite.ImageSource;
import org.arquillian.rusheye.suite.TypeProperties;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(name="Properties", propOrder={"any"})
@XmlSeeAlso(value={TypeProperties.class, ImageSource.class})
public class Properties {
    protected List<Element> any;

    @XmlAnyElement(lax=false)
    public List<Element> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Element>();
        }
        return this.any;
    }

    public Object getProperty(final String key) {
        Collection<Element> elements = FilterCollection.filter(this.getAny(), new Predicate<Element>(){

            @Override
            public boolean apply(Element element) {
                return element.getLocalName().equals(key);
            }
        });
        if (elements.isEmpty()) {
            return null;
        }
        return elements.iterator().next().getTextContent();
    }

    public void setProperty(String key, Object value) {
        Element elementForRemoval = null;
        for (Element element : this.getAny()) {
            if (!element.getLocalName().equals(key)) continue;
            elementForRemoval = element;
        }
        if (elementForRemoval != null) {
            this.getAny().remove(elementForRemoval);
        }
        SimpleElement element = new SimpleElement(key);
        element.setTextContent(value.toString());
        this.getAny().add(element);
    }

    public void include(Properties includeProperties) {
        for (Element element : includeProperties.getAny()) {
            this.setProperty(element.getLocalName(), element.getTextContent());
        }
    }

    public int size() {
        return this.getAny().size();
    }

    public <T> T getProperty(String propertyKey, Class<T> tClass) {
        Constructor<T> constructor;
        Object object = this.getProperty(propertyKey);
        if (object == null) {
            return null;
        }
        try {
            constructor = tClass.getConstructor(String.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("can't automatically convert property '" + propertyKey + "', the constructor " + tClass.getName() + "(String) can't be access", e);
        }
        try {
            return constructor.newInstance(object.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException("can't automatically convert property, the call to " + tClass.getName() + "(\"" + propertyKey + "\") failed", e);
        }
    }

    public <T> T getProperty(String propertyKey, T defaultValue, Class<T> tClass) {
        T result = this.getProperty(propertyKey, tClass);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }
}

