/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.rusheye.suite.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.apache.commons.lang.ArrayUtils;
import org.arquillian.rusheye.suite.annotations.Nullify;

public final class NullingProxy {
    private NullingProxy() {
    }

    public static <T> T handle(T instance, Class<? extends Annotation> nullified) throws InstantiationException, IllegalAccessException {
        Class<?> originalClass = instance.getClass();
        if (instance instanceof ProxyObject) {
            originalClass = originalClass.getSuperclass();
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(originalClass);
        Class proxyClass = proxyFactory.createClass();
        NullingHandler handler = new NullingHandler(instance, nullified);
        Object proxyInstance = proxyClass.newInstance();
        ((ProxyObject)proxyInstance).setHandler(handler);
        return proxyInstance;
    }

    public static class NullingHandler
    implements InvocationHandler,
    MethodHandler {
        Object object;
        Class<? extends Annotation> nullified;

        public NullingHandler(Object object, Class<? extends Annotation> nullified) {
            this.object = object;
            this.nullified = nullified;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Nullify nullify = method.getAnnotation(Nullify.class);
            if (nullify != null && ArrayUtils.contains(nullify.value(), this.nullified)) {
                return null;
            }
            Object result = method.invoke(this.object, args);
            if (result == null) {
                return result;
            }
            if (method.getReturnType().isInterface()) {
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{method.getReturnType()}, (InvocationHandler)new NullingHandler(result, this.nullified));
            }
            if (this.canBeProxied(result)) {
                return NullingProxy.handle(result, this.nullified);
            }
            return result;
        }

        private boolean canBeProxied(Object object) {
            Class<?> type = object.getClass();
            int mod = type.getModifiers();
            return !Modifier.isFinal(mod) && !Modifier.isPrivate(mod) && this.hasNoParametricConstructor(type);
        }

        private boolean hasNoParametricConstructor(Class<?> type) {
            try {
                type.getConstructor(new Class[0]);
                return true;
            }
            catch (SecurityException e) {
                throw new IllegalStateException(e);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }

        @Override
        public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            return this.invoke(self, thisMethod, args);
        }
    }
}

