/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.execution;

import java.util.concurrent.Callable;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.execution.ExecutionService;
import org.arquillian.spacelift.execution.Tasks;

public abstract class Task<IN, OUT> {
    private Task<?, ? extends IN> previous;
    private ExecutionService executionService;

    public <OUT_2, TASK_2 extends Task<? super OUT, OUT_2>> TASK_2 then(Class<TASK_2> nextTask) {
        TASK_2 next = Tasks.prepare(nextTask);
        ((Task)next).setPreviousTask(this);
        return next;
    }

    public Execution<OUT> execute() throws ExecutionException {
        if (this.getExecutionService() == null) {
            throw new ExecutionException("Unable to execute a task, execution service was not set.", new Object[0]);
        }
        return this.getExecutionService().execute(new Callable<OUT>(){

            @Override
            public OUT call() throws Exception {
                return Task.this.run();
            }
        });
    }

    protected abstract OUT process(IN var1) throws Exception;

    protected OUT run() throws ExecutionException {
        IN in = null;
        if (this.previous != null) {
            in = this.previous.run();
        }
        try {
            return this.process(in);
        }
        catch (Exception e) {
            throw new ExecutionException(e, "Unable to execute task {0}", this.getClass().getSimpleName());
        }
    }

    protected ExecutionService getExecutionService() {
        return this.executionService;
    }

    protected void setPreviousTask(Task<?, ? extends IN> previous) {
        this.previous = previous;
    }

    protected Task<IN, OUT> setExecutionService(ExecutionService executionService) {
        this.executionService = executionService;
        return this;
    }
}

