/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.execution;

import org.arquillian.spacelift.execution.ExecutionServiceFactory;
import org.arquillian.spacelift.execution.SecurityActions;
import org.arquillian.spacelift.execution.Task;

public class Tasks {
    private static ExecutionServiceFactory getAsSingleton() {
        return ExecutionServiceFactoryHolder.lastFactory;
    }

    public static ExecutionServiceFactory getExecutionServiceFactoryInstance() throws IllegalStateException {
        ExecutionServiceFactory factory = Tasks.getAsSingleton();
        if (factory == null) {
            throw new IllegalStateException("ExecutionServiceFactory was null. If you are not running from Arquillian, make sure that you set it up first.");
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultExecutionServiceFactory(ExecutionServiceFactory executionServiceFactory) {
        Class<ExecutionServiceFactoryHolder> clazz = ExecutionServiceFactoryHolder.class;
        synchronized (ExecutionServiceFactoryHolder.class) {
            ExecutionServiceFactoryHolder.lastFactory = executionServiceFactory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static <IN, OUT, TASK extends Task<? super IN, OUT>> TASK prepare(Class<TASK> taskDef) {
        Task task = (Task)SecurityActions.newInstance(taskDef);
        task.setExecutionService(Tasks.getExecutionServiceFactoryInstance().getExecutionServiceInstance());
        return (TASK)task;
    }

    public static <IN, OUT, TASK extends Task<? super IN, OUT>> TASK chain(IN input, Class<TASK> taskDef) {
        InjectTask task = SecurityActions.newInstance(InjectTask.class);
        task.setExecutionService(Tasks.getExecutionServiceFactoryInstance().getExecutionServiceInstance());
        return task.passToNext(input).then(taskDef);
    }

    public static final class InjectTask<NEXT_IN>
    extends Task<Object, NEXT_IN> {
        private NEXT_IN nextIn;

        public InjectTask<NEXT_IN> passToNext(NEXT_IN next) {
            this.nextIn = next;
            return this;
        }

        @Override
        protected NEXT_IN process(Object input) throws Exception {
            return this.nextIn;
        }
    }

    private static class ExecutionServiceFactoryHolder {
        public static ExecutionServiceFactory lastFactory = null;

        private ExecutionServiceFactoryHolder() {
        }
    }
}

