/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.spacelift.ImplementationLoader;
import org.arquillian.spacelift.Invokable;
import org.arquillian.spacelift.execution.ExecutionService;
import org.arquillian.spacelift.task.InjectTask;
import org.arquillian.spacelift.task.InvalidTaskException;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.TaskRegistry;

public class Spacelift {
    public static <IN, OUT, TASK extends Task<? super IN, OUT>> TASK task(Class<TASK> taskDef) {
        return new SpaceliftInstance().registry().find(taskDef);
    }

    public static Task<?, ?> task(String alias) throws InvalidTaskException {
        return new SpaceliftInstance().registry().find(alias);
    }

    public static <IN, OUT, TASK extends Task<? super IN, OUT>> TASK task(IN input, Class<TASK> taskDef) {
        InjectTask task = new SpaceliftInstance().registry().find(InjectTask.class);
        return task.passToNext(input).then(taskDef);
    }

    public static Task<?, ?> task(Object input, String alias) throws InvalidTaskException {
        InjectTask task = new SpaceliftInstance().registry().find(InjectTask.class);
        return task.passToNext(input).then(alias);
    }

    public static TaskRegistry registry() {
        return new SpaceliftInstance().registry();
    }

    public static ExecutionService service() {
        return new SpaceliftInstance().service();
    }

    private static class SpaceliftInstance {
        private static final Logger log = Logger.getLogger(Spacelift.class.getName());
        private static ExecutionService service;
        private static TaskRegistry registry;

        private SpaceliftInstance() {
        }

        public TaskRegistry registry() {
            return registry;
        }

        public ExecutionService service() {
            return service;
        }

        static {
            try {
                service = ImplementationLoader.implementationOf(ExecutionService.class);
            }
            catch (Invokable.InvocationException e) {
                e.printStackTrace();
                log.log(Level.SEVERE, "Unable to find default implemenation of {0} on classpath, make sure that you set one programatically.", ExecutionService.class.getName());
            }
            try {
                registry = ImplementationLoader.implementationOf(TaskRegistry.class);
                registry.register(InjectTask.class, new String[0]);
            }
            catch (Invokable.InvocationException e) {
                log.log(Level.SEVERE, "Unable to find default implemenation of {0} on classpath, make sure that you set one programatically.", TaskRegistry.class.getName());
            }
        }
    }
}

