/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.execution;

import java.util.concurrent.TimeUnit;

public class CountDownWatch {
    private long timeStart = System.currentTimeMillis();
    private long timeout;
    private TimeUnit unit;

    public CountDownWatch(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    public long timeLeft() {
        long currentTime = System.currentTimeMillis();
        long timeoutInMillis = TimeUnit.MILLISECONDS.convert(this.timeout, this.unit);
        return timeoutInMillis - (currentTime - this.timeStart);
    }

    public long timeElapsed() {
        long currentTime = System.currentTimeMillis();
        return this.unit.convert(currentTime - this.timeStart, TimeUnit.MILLISECONDS);
    }

    public void reset() {
        this.timeStart = System.currentTimeMillis();
    }

    public long timeout() {
        return this.timeout;
    }

    public TimeUnit getTimeUnit() {
        return this.unit;
    }
}

