/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.text;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.text.ReplacementTuple;

public class StringReplacementTask
extends Task<Map<File, String>, Map<File, String>> {
    private List<ReplacementTuple<?>> replacements = new ArrayList();

    public ReplacementTuple<StringReplacementTask> replace(String regex) {
        ReplacementTuple<StringReplacementTask> replacement = new ReplacementTuple<StringReplacementTask>(this, regex);
        this.replacements.add(replacement);
        return replacement;
    }

    public StringReplacementTask replace(Collection<ReplacementTuple<?>> replacements) {
        this.replacements.addAll(replacements);
        return this;
    }

    protected Map<File, String> process(Map<File, String> input) throws Exception {
        for (File file : input.keySet()) {
            String content = input.get(file);
            for (ReplacementTuple<?> tuple : this.replacements) {
                if (tuple.getRegex() == null || tuple.getReplacement() == null) continue;
                content = content.replaceAll(tuple.getRegex(), tuple.getReplacement());
            }
            input.put(file, content);
        }
        return input;
    }
}

