/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.execution.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.arquillian.spacelift.execution.Execution;

public class ShutdownHooks {
    public static <RETURNTYPE> void addHookFor(Execution<RETURNTYPE> execution) {
        SpaceliftShutDownHook<RETURNTYPE> shutdownThread = new SpaceliftShutDownHook<RETURNTYPE>(execution);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    public static class SpaceliftShutDownHook<RETURNTYPE>
    extends Thread {
        private static AtomicInteger shutdownCounter = new AtomicInteger(1);
        private final Execution<RETURNTYPE> execution;

        public SpaceliftShutDownHook(Execution<RETURNTYPE> execution) {
            super("spacelift-shutdown-hook-" + shutdownCounter.getAndIncrement());
            this.execution = execution;
        }

        @Override
        public void run() {
            if (this.execution != null && !this.execution.isFinished() && !this.execution.isMarkedAsFinished()) {
                this.execution.terminate();
            }
        }
    }
}

