/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.artificer.atom.ArtificerAtomUtils;
import org.artificer.atom.archive.ArtificerArchive;
import org.artificer.atom.beans.HttpResponseBean;
import org.artificer.client.ArtificerClientException;
import org.artificer.client.ArtificerClientQuery;
import org.artificer.client.ClientRequest;
import org.artificer.client.audit.AuditResultSet;
import org.artificer.client.auth.AuthenticationProvider;
import org.artificer.client.auth.BasicAuthenticationProvider;
import org.artificer.client.i18n.Messages;
import org.artificer.client.ontology.OntologySummary;
import org.artificer.client.query.QueryResultSet;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.MediaType;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.common.query.ArtifactSummary;
import org.jboss.downloads.artificer._2013.auditing.AuditEntry;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.plugins.providers.atom.Category;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.app.AppCategories;
import org.jboss.resteasy.plugins.providers.atom.app.AppCollection;
import org.jboss.resteasy.plugins.providers.atom.app.AppService;
import org.jboss.resteasy.plugins.providers.atom.app.AppWorkspace;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;

public class ArtificerAtomApiClient {
    private String endpoint;
    private String srampEndpoint;
    private String artificerEndpoint;
    private boolean validating;
    private Set<String> enabledFeatures = new HashSet<String>();
    private Locale locale;
    private AuthenticationProvider authProvider;

    public ArtificerAtomApiClient(String endpoint) {
        this.endpoint = endpoint;
        if (this.endpoint.endsWith("/")) {
            this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 1);
        }
        if (this.endpoint.endsWith("/s-ramp")) {
            this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 7);
        }
        if (this.endpoint.endsWith("/artificer")) {
            this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 10);
        }
        this.srampEndpoint = endpoint + "/s-ramp";
        this.artificerEndpoint = endpoint + "/artificer";
    }

    public ArtificerAtomApiClient(String endpoint, boolean validating) throws ArtificerClientException, ArtificerServerException {
        this(endpoint);
        this.validating = validating;
        if (this.validating) {
            this.discoverAvailableFeatures();
        }
    }

    public ArtificerAtomApiClient(String endpoint, String username, String password, boolean validating) throws ArtificerClientException, ArtificerServerException {
        this(endpoint, new BasicAuthenticationProvider(username, password), validating);
    }

    public ArtificerAtomApiClient(String endpoint, AuthenticationProvider authenticationProvider, boolean validating) throws ArtificerClientException, ArtificerServerException {
        this(endpoint);
        this.authProvider = authenticationProvider;
        this.validating = validating;
        if (this.validating) {
            this.discoverAvailableFeatures();
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    private void discoverAvailableFeatures() throws ArtificerClientException, ArtificerServerException {
        AppService serviceDoc = this.getServiceDocument();
        for (AppWorkspace workspace : serviceDoc.getWorkspace()) {
            for (AppCollection collection : workspace.getCollection()) {
                for (AppCategories cats : collection.getCategories()) {
                    for (Category category : cats.getCategory()) {
                        this.enabledFeatures.add(category.getTerm());
                    }
                }
            }
        }
    }

    private void assertFeatureEnabled(String feature) throws ArtificerClientException {
        if (this.validating && !this.enabledFeatures.contains(feature)) {
            throw new ArtificerClientException(Messages.i18n.format("FEATURE_NOT_SUPPORTED", new Object[0]));
        }
    }

    private void assertFeatureEnabled(ArtifactType feature) throws ArtificerClientException {
        if (this.validating && !this.enabledFeatures.contains(feature.getArtifactType().getType())) {
            throw new ArtificerClientException(Messages.i18n.format("FEATURE_NOT_SUPPORTED", new Object[0]));
        }
    }

    public AppService getServiceDocument() throws ArtificerClientException, ArtificerServerException {
        ClientResponse<AppService> response = null;
        try {
            String atomUrl = String.format("%1$s/servicedocument", this.srampEndpoint);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.get(AppService.class);
            AppService appService = (AppService)response.getEntity();
            return appService;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public BaseArtifactType getArtifactMetaData(String artifactUuid) throws ArtificerClientException, ArtificerServerException {
        try {
            QueryResultSet uuidRS = this.buildQuery("/s-ramp[@uuid = ?]").parameter(artifactUuid).count(1).query();
            if (uuidRS.size() == 0L) {
                throw new ArtificerClientException(Messages.i18n.format("ARTIFACT_NOT_FOUND", new Object[]{artifactUuid}));
            }
            return this.getArtifactMetaData(uuidRS.iterator().next());
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
    }

    public BaseArtifactType getArtifactMetaData(ArtifactSummary artifact) throws ArtificerClientException, ArtificerServerException {
        return this.getArtifactMetaData(artifact.getArtifactType(), artifact.getUuid());
    }

    public BaseArtifactType getArtifactMetaData(ArtifactType artifactType, String artifactUuid) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled(artifactType);
        ClientResponse<Entry> response = null;
        try {
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s", this.srampEndpoint, artifactType.getArtifactType().getModel(), artifactType.getArtifactType().getType(), artifactUuid);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.get(Entry.class);
            Entry entry = (Entry)response.getEntity();
            BaseArtifactType baseArtifactType = ArtificerAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)entry);
            return baseArtifactType;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public InputStream getArtifactContent(ArtifactType artifactType, String artifactUuid) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled(artifactType);
        try {
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s/media", this.srampEndpoint, artifactType.getArtifactType().getModel(), artifactType.getArtifactType().getType(), artifactUuid);
            DefaultHttpClient httpClient = new DefaultHttpClient();
            if (this.authProvider != null) {
                httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

                    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                        ArtificerAtomApiClient.this.authProvider.provideAuthentication(request);
                    }
                });
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(atomUrl));
            HttpEntity entity = response.getEntity();
            return entity.getContent();
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
    }

    public InputStream getArtifactContent(ArtifactSummary artifact) throws ArtificerClientException, ArtificerServerException {
        return this.getArtifactContent(artifact.getArtifactType(), artifact.getUuid());
    }

    public BaseArtifactType createArtifact(BaseArtifactType artifact) throws ArtificerClientException, ArtificerServerException {
        ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)artifact);
        if (ArtificerModelUtils.isDocumentArtifact((BaseArtifactType)artifact)) {
            throw new ArtificerClientException(Messages.i18n.format("MISSING_ARTIFACT_CONTEN", new Object[0]));
        }
        this.assertFeatureEnabled(artifactType);
        ClientResponse<Entry> response = null;
        try {
            String type = artifactType.getType();
            String atomUrl = String.format("%1$s/%2$s/%3$s", this.srampEndpoint, artifactType.getModel(), type);
            ClientRequest request = this.createClientRequest(atomUrl);
            request.body("application/atom+xml;type=entry", ArtificerAtomUtils.wrapSrampArtifact((BaseArtifactType)artifact));
            response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            BaseArtifactType baseArtifactType = ArtificerAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)entry);
            return baseArtifactType;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public BaseArtifactType uploadArtifact(ArtifactType artifactType, InputStream content, String artifactFileName) throws ArtificerClientException, ArtificerServerException {
        if (artifactType == null) {
            return this.uploadArtifact(content, artifactFileName);
        }
        this.assertFeatureEnabled(artifactType);
        ClientResponse<Entry> response = null;
        try {
            String type = artifactType.getType();
            String atomUrl = String.format("%1$s/%2$s/%3$s", this.srampEndpoint, artifactType.getArtifactType().getModel(), type);
            ClientRequest request = this.createClientRequest(atomUrl);
            if (artifactFileName != null) {
                request.header("Slug", artifactFileName);
            }
            request.body(artifactType.getMimeType(), content);
            response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            BaseArtifactType baseArtifactType = ArtificerAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)entry);
            return baseArtifactType;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public BaseArtifactType uploadArtifact(InputStream content, String artifactFileName) throws ArtificerClientException, ArtificerServerException {
        ClientResponse<Entry> response = null;
        try {
            ClientRequest request = this.createClientRequest(this.srampEndpoint + "/autodetect");
            request.header("Slug", artifactFileName);
            request.body("application/octet-stream", content);
            response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            BaseArtifactType baseArtifactType = ArtificerAtomUtils.unwrapSrampArtifact((Entry)entry);
            return baseArtifactType;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public BaseArtifactType uploadArtifact(BaseArtifactType baseArtifactType, InputStream content) throws ArtificerClientException, ArtificerServerException {
        ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)baseArtifactType);
        this.assertFeatureEnabled(artifactType);
        ClientResponse<Entry> response = null;
        try {
            String type = artifactType.getType();
            String atomUrl = String.format("%1$s/%2$s/%3$s", this.srampEndpoint, artifactType.getArtifactType().getModel(), type);
            ClientRequest request = this.createClientRequest(atomUrl);
            MultipartRelatedOutput output = new MultipartRelatedOutput();
            Entry atomEntry = ArtificerAtomUtils.wrapSrampArtifact((BaseArtifactType)baseArtifactType);
            MediaType mediaType = new MediaType("application", "atom+xml");
            output.addPart((Object)atomEntry, (javax.ws.rs.core.MediaType)mediaType);
            request.body(artifactType.getMimeType(), content);
            MediaType mediaType2 = MediaType.getInstance((String)artifactType.getMimeType());
            output.addPart((Object)content, (javax.ws.rs.core.MediaType)mediaType2);
            request.body("multipart/related", output);
            response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            BaseArtifactType baseArtifactType2 = ArtificerAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)entry);
            return baseArtifactType2;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, ?> uploadBatch(ArtificerArchive archive) throws ArtificerClientException, ArtificerServerException {
        HashMap<String, Object> hashMap;
        ClientResponse<MultipartInput> clientResponse;
        FileInputStream packageStream;
        File packageFile;
        block10: {
            packageFile = null;
            packageStream = null;
            clientResponse = null;
            if (!archive.getEntries().isEmpty()) break block10;
            HashMap hashMap2 = new HashMap();
            IOUtils.closeQuietly(packageStream);
            FileUtils.deleteQuietly((File)packageFile);
            this.closeQuietly(clientResponse);
            return hashMap2;
        }
        try {
            packageFile = archive.pack();
            packageStream = FileUtils.openInputStream((File)packageFile);
            ClientRequest request = this.createClientRequest(this.srampEndpoint);
            request.header("Content-Type", "application/zip");
            request.body("application/zip", packageStream);
            clientResponse = request.post(MultipartInput.class);
            MultipartInput response = (MultipartInput)clientResponse.getEntity();
            List parts = response.getParts();
            HashMap<String, Object> rval = new HashMap<String, Object>(parts.size());
            for (InputPart part : parts) {
                ArtificerServerException exception;
                String contentId = (String)part.getHeaders().getFirst((Object)"Content-ID");
                String path = contentId.substring(1, contentId.lastIndexOf(64));
                HttpResponseBean rbean = (HttpResponseBean)part.getBody(HttpResponseBean.class, null);
                if (rbean.getCode() == 201) {
                    Entry entry = (Entry)rbean.getBody();
                    BaseArtifactType artifact = ArtificerAtomUtils.unwrapSrampArtifact((Entry)entry);
                    rval.put(path, artifact);
                    continue;
                }
                if (rbean.getCode() == 409) {
                    if ("application/artificer-server-exception".equals(rbean.getHeaders().get("Content-Type"))) {
                        exception = (ArtificerServerException)((Object)rbean.getBody());
                        rval.put(path, (Object)exception);
                        continue;
                    }
                    String errorReason = (String)rbean.getBody();
                    ArtificerServerException exception2 = new ArtificerServerException(errorReason);
                    rval.put(path, (Object)exception2);
                    continue;
                }
                exception = new ArtificerServerException(Messages.i18n.format("BAD_RETURN_CODE", new Object[]{rbean.getCode(), contentId}));
                rval.put(path, (Object)exception);
            }
            hashMap = rval;
        }
        catch (ArtificerServerException e) {
            try {
                throw e;
                catch (Throwable e2) {
                    throw new ArtificerClientException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(packageStream);
                FileUtils.deleteQuietly(packageFile);
                this.closeQuietly(clientResponse);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)packageStream);
        FileUtils.deleteQuietly((File)packageFile);
        this.closeQuietly(clientResponse);
        return hashMap;
    }

    public void updateArtifactMetaData(BaseArtifactType artifact) throws ArtificerClientException, ArtificerServerException {
        ArtifactType type = ArtifactType.valueOf((BaseArtifactType)artifact);
        this.assertFeatureEnabled(type);
        ClientResponse response = null;
        try {
            String artifactModel = type.getArtifactType().getModel();
            String artifactType = type.getArtifactType().getType();
            if ("ext".equals(type.getArtifactType().getModel()) && type.getExtendedType() != null) {
                artifactType = type.getExtendedType();
            }
            String artifactUuid = artifact.getUuid();
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s", this.srampEndpoint, artifactModel, artifactType, artifactUuid);
            ClientRequest request = this.createClientRequest(atomUrl);
            Entry entry = ArtificerAtomUtils.wrapSrampArtifact((BaseArtifactType)artifact);
            request.body("application/atom+xml;type=entry", entry);
            response = request.put();
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public BaseArtifactType addComment(String uuid, ArtifactType type, String text) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled(type);
        ClientResponse<Entry> response = null;
        try {
            String artifactModel = type.getArtifactType().getModel();
            String artifactType = type.getArtifactType().getType();
            if ("ext".equals(type.getArtifactType().getModel()) && type.getExtendedType() != null) {
                artifactType = type.getExtendedType();
            }
            String atomUrl = String.format("%1$s/%2$s/%3$s/%4$s/comment", this.srampEndpoint, artifactModel, artifactType, uuid);
            ClientRequest request = this.createClientRequest(atomUrl);
            request.body("text/plain", text);
            response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            BaseArtifactType baseArtifactType = ArtificerAtomUtils.unwrapSrampArtifact((ArtifactType)type, (Entry)entry);
            return baseArtifactType;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public void deleteArtifact(String uuid, ArtifactType type) throws ArtificerClientException, ArtificerServerException {
        this.deleteArtifact(uuid, type, false);
    }

    public void deleteArtifact(String uuid, ArtifactType type, boolean force) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled(type);
        ClientResponse response = null;
        try {
            String artifactModel = type.getArtifactType().getModel();
            String artifactType = type.getArtifactType().getType();
            if ("ext".equals(type.getArtifactType().getModel()) && type.getExtendedType() != null) {
                artifactType = type.getExtendedType();
            }
            String artifactUuid = uuid;
            String atomUrl = force ? String.format("%1$s/%2$s/%3$s/%4$s/force", this.srampEndpoint, artifactModel, artifactType, artifactUuid) : String.format("%1$s/%2$s/%3$s/%4$s", this.srampEndpoint, artifactModel, artifactType, artifactUuid);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.delete();
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public QueryResultSet query(String srampQuery) throws ArtificerClientException, ArtificerServerException {
        return this.query(srampQuery, 0, 20, "name", true);
    }

    public QueryResultSet query(String srampQuery, int startIndex, int count, String orderBy, boolean ascending) throws ArtificerClientException, ArtificerServerException {
        return this.query(srampQuery, startIndex, count, orderBy, ascending, null);
    }

    public QueryResultSet query(String srampQuery, int startIndex, int count, String orderBy, boolean ascending, Collection<String> propertyNames) throws ArtificerClientException, ArtificerServerException {
        ClientResponse<Feed> response = null;
        try {
            String xpath = srampQuery;
            if (xpath == null) {
                throw new Exception(Messages.i18n.format("INVALID_QUERY_FORMAT", new Object[0]));
            }
            if (xpath.startsWith("/s-ramp/")) {
                xpath = xpath.substring(8);
            }
            String atomUrl = this.srampEndpoint;
            if (propertyNames == null || propertyNames.size() < 2) {
                ClientRequest request = this.createClientRequest(atomUrl);
                MultipartFormDataOutput formData = new MultipartFormDataOutput();
                formData.addFormData("query", (Object)xpath, MediaType.TEXT_PLAIN_TYPE);
                formData.addFormData("startIndex", (Object)String.valueOf(startIndex), MediaType.TEXT_PLAIN_TYPE);
                formData.addFormData("count", (Object)String.valueOf(count), MediaType.TEXT_PLAIN_TYPE);
                formData.addFormData("orderBy", (Object)orderBy, MediaType.TEXT_PLAIN_TYPE);
                formData.addFormData("ascending", (Object)String.valueOf(ascending), MediaType.TEXT_PLAIN_TYPE);
                if (propertyNames != null) {
                    for (String propertyName : propertyNames) {
                        formData.addFormData("propertyName", (Object)propertyName, MediaType.TEXT_PLAIN_TYPE);
                    }
                }
                request.body(MediaType.MULTIPART_FORM_DATA_TYPE, formData);
                response = request.post(Feed.class);
                QueryResultSet queryResultSet = new QueryResultSet((Feed)response.getEntity());
                return queryResultSet;
            }
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(atomUrl);
            urlBuilder.append("?query=");
            urlBuilder.append(URLEncoder.encode(srampQuery, "UTF8"));
            urlBuilder.append("&startIndex=");
            urlBuilder.append(String.valueOf(startIndex));
            urlBuilder.append("&count=");
            urlBuilder.append(String.valueOf(count));
            urlBuilder.append("&orderBy=");
            urlBuilder.append(URLEncoder.encode(orderBy, "UTF8"));
            urlBuilder.append("&ascending=");
            urlBuilder.append(String.valueOf(ascending));
            for (String propName : propertyNames) {
                urlBuilder.append("&propertyName=");
                urlBuilder.append(URLEncoder.encode(propName, "UTF8"));
            }
            ClientRequest request = this.createClientRequest(urlBuilder.toString());
            response = request.get(Feed.class);
            QueryResultSet queryResultSet = new QueryResultSet((Feed)response.getEntity());
            return queryResultSet;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public ArtificerClientQuery buildQuery(String query) {
        return new ArtificerClientQuery(this, query);
    }

    public RDF addOntology(RDF ontology) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("ontology");
        ClientResponse<Entry> response = null;
        try {
            String atomUrl = String.format("%1$s/ontology", this.srampEndpoint);
            ClientRequest request = this.createClientRequest(atomUrl);
            request.body((javax.ws.rs.core.MediaType)MediaType.APPLICATION_RDF_XML_TYPE, ontology);
            response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            RDF rdf = (RDF)ArtificerAtomUtils.unwrap((Entry)entry, RDF.class);
            rdf.getOtherAttributes().put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "uuid"), entry.getId().toString().replace("urn:uuid:", ""));
            RDF rDF = rdf;
            return rDF;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public RDF uploadOntology(InputStream content) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("ontology");
        ClientResponse<Entry> response = null;
        try {
            String atomUrl = String.format("%1$s/ontology", this.srampEndpoint);
            ClientRequest request = this.createClientRequest(atomUrl);
            request.body((javax.ws.rs.core.MediaType)MediaType.APPLICATION_RDF_XML_TYPE, content);
            response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            RDF rdf = (RDF)ArtificerAtomUtils.unwrap((Entry)entry, RDF.class);
            rdf.getOtherAttributes().put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "uuid"), entry.getId().toString().replace("urn:uuid:", ""));
            RDF rDF = rdf;
            return rDF;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public void updateOntology(String ontologyUuid, InputStream content) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("ontology");
        ClientResponse response = null;
        try {
            String atomUrl = String.format("%1$s/ontology/%2$s", this.srampEndpoint, ontologyUuid);
            ClientRequest request = this.createClientRequest(atomUrl);
            request.body((javax.ws.rs.core.MediaType)MediaType.APPLICATION_RDF_XML_TYPE, content);
            response = request.put();
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public void updateOntology(String ontologyUuid, RDF ontology) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("ontology");
        ClientResponse response = null;
        try {
            String atomUrl = String.format("%1$s/ontology/%2$s", this.srampEndpoint, ontologyUuid);
            ClientRequest request = this.createClientRequest(atomUrl);
            request.body((javax.ws.rs.core.MediaType)MediaType.APPLICATION_RDF_XML_TYPE, ontology);
            response = request.put();
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public List<OntologySummary> getOntologies() throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("ontology");
        ClientResponse<Feed> response = null;
        try {
            String atomUrl = String.format("%1$s/ontology", this.srampEndpoint);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.get(Feed.class);
            Feed feed = (Feed)response.getEntity();
            ArrayList<OntologySummary> rval = new ArrayList<OntologySummary>(feed.getEntries().size());
            for (Entry entry : feed.getEntries()) {
                OntologySummary summary = new OntologySummary(entry);
                rval.add(summary);
            }
            ArrayList<OntologySummary> arrayList = rval;
            return arrayList;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public RDF getOntology(String ontologyUuid) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("ontology");
        ClientResponse<Entry> response = null;
        try {
            String atomUrl = String.format("%1$s/ontology/%2$s", this.srampEndpoint, ontologyUuid);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.get(Entry.class);
            Entry entry = (Entry)response.getEntity();
            RDF rdf = ArtificerAtomUtils.unwrapRDF((Entry)entry);
            rdf.getOtherAttributes().put(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "uuid"), entry.getId().toString().replace("urn:uuid:", ""));
            RDF rDF = rdf;
            return rDF;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public void deleteOntology(String ontologyUuid) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("ontology");
        ClientResponse response = null;
        try {
            String atomUrl = String.format("%1$s/ontology/%2$s", this.srampEndpoint, ontologyUuid);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.delete();
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public StoredQuery createStoredQuery(StoredQuery storedQuery) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("query");
        ClientResponse<Entry> response = null;
        try {
            String atomUrl = String.format("%1$s/query", this.srampEndpoint);
            ClientRequest request = this.createClientRequest(atomUrl);
            request.body("application/atom+xml;type=entry", ArtificerAtomUtils.wrapStoredQuery((StoredQuery)storedQuery));
            response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            StoredQuery storedQuery2 = ArtificerAtomUtils.unwrapStoredQuery((Entry)entry);
            return storedQuery2;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public void updateStoredQuery(String queryName, StoredQuery storedQuery) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("query");
        ClientResponse response = null;
        try {
            String atomUrl = String.format("%1$s/query/%2$s", this.srampEndpoint, queryName);
            ClientRequest request = this.createClientRequest(atomUrl);
            request.body("application/atom+xml;type=entry", ArtificerAtomUtils.wrapStoredQuery((StoredQuery)storedQuery));
            response = request.put();
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public List<StoredQuery> getStoredQueries() throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("query");
        ClientResponse<Feed> response = null;
        try {
            String atomUrl = String.format("%1$s/query", this.srampEndpoint);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.get(Feed.class);
            Feed feed = (Feed)response.getEntity();
            ArrayList<StoredQuery> storedQueries = new ArrayList<StoredQuery>(feed.getEntries().size());
            for (Entry entry : feed.getEntries()) {
                storedQueries.add(ArtificerAtomUtils.unwrapStoredQuery((Entry)entry));
            }
            ArrayList<StoredQuery> arrayList = storedQueries;
            return arrayList;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public StoredQuery getStoredQuery(String queryName) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("query");
        ClientResponse<Entry> response = null;
        try {
            String atomUrl = String.format("%1$s/query/%2$s", this.srampEndpoint, queryName);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.get(Entry.class);
            Entry entry = (Entry)response.getEntity();
            StoredQuery storedQuery = ArtificerAtomUtils.unwrapStoredQuery((Entry)entry);
            return storedQuery;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public void deleteStoredQuery(String queryName) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("query");
        ClientResponse response = null;
        try {
            String atomUrl = String.format("%1$s/query/%2$s", this.srampEndpoint, queryName);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.delete();
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public QueryResultSet queryWithStoredQuery(String queryName) throws ArtificerClientException, ArtificerServerException {
        return this.queryWithStoredQuery(queryName, 0, 20, "name", true);
    }

    public QueryResultSet queryWithStoredQuery(String queryName, int startIndex, int count, String orderBy, boolean ascending) throws ArtificerClientException, ArtificerServerException {
        ClientResponse<Feed> response = null;
        try {
            String atomUrl = String.format("%1$s/query/%2$s/results", this.srampEndpoint, queryName);
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(atomUrl);
            urlBuilder.append("?startIndex=");
            urlBuilder.append(String.valueOf(startIndex));
            urlBuilder.append("&count=");
            urlBuilder.append(String.valueOf(count));
            urlBuilder.append("&orderBy=");
            urlBuilder.append(URLEncoder.encode(orderBy, "UTF8"));
            urlBuilder.append("&ascending=");
            urlBuilder.append(String.valueOf(ascending));
            ClientRequest request = this.createClientRequest(urlBuilder.toString());
            response = request.get(Feed.class);
            QueryResultSet queryResultSet = new QueryResultSet((Feed)response.getEntity());
            return queryResultSet;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public ArtificerClientQuery buildQueryWithStoredQuery(StoredQuery storedQuery) {
        return this.buildQuery(storedQuery.getQueryExpression());
    }

    public AuditEntry addAuditEntry(String artifactUuid, AuditEntry auditEntry) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("audit");
        ClientResponse<Entry> response = null;
        try {
            String atomUrl = String.format("%1$s/audit/artifact/%2$s", this.srampEndpoint, artifactUuid);
            ClientRequest request = this.createClientRequest(atomUrl);
            request.body((javax.ws.rs.core.MediaType)MediaType.APPLICATION_AUDIT_ENTRY_XML_TYPE, auditEntry);
            response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            if (entry == null) {
                throw new ArtificerServerException(Messages.i18n.format("AUDIT_ENTRY_ADD_FAILED", new Object[0]));
            }
            AuditEntry auditEntry2 = (AuditEntry)ArtificerAtomUtils.unwrap((Entry)entry, AuditEntry.class);
            return auditEntry2;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public AuditResultSet getAuditTrailForArtifact(String artifactUuid) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("audit");
        ClientResponse<Feed> response = null;
        try {
            AuditResultSet rs;
            String atomUrl = String.format("%1$s/audit/artifact/%2$s", this.srampEndpoint, artifactUuid);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.get(Feed.class);
            Feed feed = (Feed)response.getEntity();
            AuditResultSet auditResultSet = rs = new AuditResultSet(feed);
            return auditResultSet;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public AuditResultSet getAuditTrailForArtifact(String artifactUuid, int startIndex, int count) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("audit");
        ClientResponse<Feed> response = null;
        try {
            AuditResultSet rs;
            String atomUrl = String.format("%1$s/audit/artifact/%2$s?startIndex=%3$s&count=%4$s", this.srampEndpoint, artifactUuid, String.valueOf(startIndex), String.valueOf(count));
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.get(Feed.class);
            Feed feed = (Feed)response.getEntity();
            AuditResultSet auditResultSet = rs = new AuditResultSet(feed);
            return auditResultSet;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public AuditResultSet getAuditTrailForUser(String username) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("audit");
        ClientResponse<Feed> response = null;
        try {
            AuditResultSet rs;
            String atomUrl = String.format("%1$s/audit/user/%2$s", this.srampEndpoint, username);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.get(Feed.class);
            Feed feed = (Feed)response.getEntity();
            AuditResultSet auditResultSet = rs = new AuditResultSet(feed);
            return auditResultSet;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public AuditResultSet getAuditTrailForUser(String username, int startIndex, int count) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("audit");
        ClientResponse<Feed> response = null;
        try {
            AuditResultSet rs;
            String atomUrl = String.format("%1$s/audit/user/%2$s?startIndex=%3$s&count=%4$s", this.srampEndpoint, username, String.valueOf(startIndex), String.valueOf(count));
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.get(Feed.class);
            Feed feed = (Feed)response.getEntity();
            AuditResultSet auditResultSet = rs = new AuditResultSet(feed);
            return auditResultSet;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    public AuditEntry getAuditEntry(String artifactUuid, String auditEntryUuid) throws ArtificerClientException, ArtificerServerException {
        this.assertFeatureEnabled("audit");
        ClientResponse<Entry> response = null;
        try {
            String atomUrl = String.format("%1$s/audit/artifact/%2$s/%3$s", this.srampEndpoint, artifactUuid, auditEntryUuid);
            ClientRequest request = this.createClientRequest(atomUrl);
            response = request.get(Entry.class);
            Entry entry = (Entry)response.getEntity();
            AuditEntry auditEntry = ArtificerAtomUtils.unwrapAuditEntry((Entry)entry);
            return auditEntry;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    protected ClientRequest createClientRequest(String atomUrl) {
        ClientExecutor executor = this.createClientExecutor();
        ClientRequest request = new ClientRequest(atomUrl, executor);
        return request;
    }

    private ClientExecutor createClientExecutor() {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                Locale l = ArtificerAtomApiClient.this.getLocale();
                if (l == null) {
                    l = Locale.getDefault();
                }
                request.addHeader("Accept-Language", l.toString());
            }
        });
        if (this.authProvider != null) {
            httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    ArtificerAtomApiClient.this.authProvider.provideAuthentication(request);
                }
            });
        }
        return new ApacheHttpClient4Executor((HttpClient)httpClient);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public QueryResultSet reverseRelationships(String uuid) throws ArtificerClientException, ArtificerServerException {
        ClientResponse<Feed> response = null;
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(this.artificerEndpoint);
            urlBuilder.append("/reverseRelationship/");
            urlBuilder.append(uuid);
            ClientRequest request = this.createClientRequest(urlBuilder.toString());
            response = request.get(Feed.class);
            QueryResultSet queryResultSet = new QueryResultSet((Feed)response.getEntity());
            return queryResultSet;
        }
        catch (ArtificerServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ArtificerClientException(e);
        }
        finally {
            this.closeQuietly(response);
        }
    }

    private void closeQuietly(ClientResponse<?> response) {
        if (response != null) {
            response.releaseConnection();
        }
    }
}

