/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.client.query;

import java.util.Calendar;
import java.util.Iterator;
import org.artificer.atom.ArtificerAtomUtils;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerConstants;
import org.artificer.common.query.ArtifactSummary;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Person;

public class QueryResultSet
implements Iterable<ArtifactSummary> {
    private Feed currentFeed;

    public QueryResultSet(Feed feed) {
        this.currentFeed = feed;
    }

    public long size() {
        return this.currentFeed.getEntries().size();
    }

    public long getTotalResults() {
        Object totalResultsAttr = this.currentFeed.getExtensionAttributes().get(ArtificerConstants.SRAMP_TOTAL_RESULTS_QNAME);
        if (totalResultsAttr != null) {
            return Long.parseLong((String)totalResultsAttr);
        }
        return -1L;
    }

    public int getItemsPerPage() {
        Object itemsPerPageAttr = this.currentFeed.getExtensionAttributes().get(ArtificerConstants.SRAMP_ITEMS_PER_PAGE_QNAME);
        if (itemsPerPageAttr != null) {
            return Integer.parseInt((String)itemsPerPageAttr);
        }
        return -1;
    }

    public int getStartIndex() {
        Object startIndexAttr = this.currentFeed.getExtensionAttributes().get(ArtificerConstants.SRAMP_START_INDEX_QNAME);
        if (startIndexAttr != null) {
            return Integer.parseInt((String)startIndexAttr);
        }
        return -1;
    }

    public ArtifactSummary get(int index) {
        if (index >= this.currentFeed.getEntries().size()) {
            return null;
        }
        return QueryResultSet.summary((Entry)this.currentFeed.getEntries().get(index));
    }

    @Override
    public Iterator<ArtifactSummary> iterator() {
        return new DelegatingIterator(this.currentFeed.getEntries().iterator());
    }

    private static ArtifactSummary summary(Entry entry) {
        ArtifactSummary summary = new ArtifactSummary();
        summary.setUuid(entry.getId().toString().replace("urn:uuid:", ""));
        summary.setName(entry.getTitle());
        summary.setDescription(entry.getSummary());
        ArtifactType artifactType = ArtificerAtomUtils.getArtifactType((Entry)entry);
        summary.setModel(artifactType.getModel());
        summary.setType(artifactType.getType());
        summary.setDerived(artifactType.isDerived());
        summary.setExtensionAttributes(entry.getExtensionAttributes());
        if (entry.getPublished() != null) {
            Calendar published = Calendar.getInstance();
            published.setTime(entry.getPublished());
            summary.setCreatedTimestamp(published);
        }
        if (entry.getAuthors() != null && entry.getAuthors().size() > 0) {
            summary.setCreatedBy(((Person)entry.getAuthors().get(0)).getName());
        }
        if (entry.getUpdated() != null) {
            Calendar updated = Calendar.getInstance();
            updated.setTime(entry.getUpdated());
            summary.setLastModifiedTimestamp(updated);
        }
        summary.setExpandedFromArchive("true".equals(entry.getExtensionAttributes().get(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_QNAME)));
        return summary;
    }

    private static class DelegatingIterator
    implements Iterator<ArtifactSummary> {
        private Iterator<Entry> delegate;

        public DelegatingIterator(Iterator<Entry> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public ArtifactSummary next() {
            return QueryResultSet.summary(this.delegate.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

