/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.common;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.artificer.common.ArtifactTypeEnum;
import org.artificer.common.ArtificerConstants;
import org.artificer.common.i18n.Messages;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Artifact;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;

public class ArtifactType
implements Serializable {
    private ArtifactTypeEnum artifactType;
    private String mimeType;
    private String extendedType;
    private boolean extendedDerivedType;

    public static final boolean isValid(String artifactType) {
        for (int i = 0; i < artifactType.length(); ++i) {
            char c = artifactType.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static final ArtifactType Document() {
        return new ArtifactType(ArtifactTypeEnum.Document, "application/octet-stream");
    }

    public static final ArtifactType Document(String mimeType) {
        return new ArtifactType(ArtifactTypeEnum.Document, mimeType);
    }

    public static final ArtifactType XmlDocument() {
        return new ArtifactType(ArtifactTypeEnum.XmlDocument, "application/xml");
    }

    public static final ArtifactType XsdDocument() {
        return new ArtifactType(ArtifactTypeEnum.XsdDocument, "application/xml");
    }

    public static final ArtifactType WsdlDocument() {
        return new ArtifactType(ArtifactTypeEnum.WsdlDocument, "application/xml");
    }

    public static final ArtifactType PolicyDocument() {
        return new ArtifactType(ArtifactTypeEnum.PolicyDocument, "application/xml");
    }

    public static final ArtifactType ExtendedArtifactType(String extendedType, boolean derived) {
        ArtifactType at = new ArtifactType(ArtifactTypeEnum.ExtendedArtifactType, null);
        at.setExtendedType(extendedType);
        at.setExtendedDerivedType(derived);
        return at;
    }

    public static final ArtifactType ExtendedDocument(String extendedType) {
        ArtifactType at = new ArtifactType(ArtifactTypeEnum.ExtendedDocument, null);
        at.setExtendedType(extendedType);
        return at;
    }

    private ArtifactType(ArtifactTypeEnum artifactType, String mimeType) {
        this.setArtifactType(artifactType);
        if (mimeType == null) {
            mimeType = artifactType == ArtifactTypeEnum.Document || artifactType == ArtifactTypeEnum.ExtendedDocument ? "application/octet-stream" : "application/xml";
        }
        this.setMimeType(mimeType);
    }

    public BaseArtifactType unwrap(Artifact artifactWrapper) {
        try {
            Method method = Artifact.class.getMethod("get" + this.getArtifactType().getType(), new Class[0]);
            BaseArtifactType artifact = (BaseArtifactType)method.invoke((Object)artifactWrapper, new Object[0]);
            artifact.setArtifactType(this.getArtifactType().getApiType());
            return artifact;
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.i18n.format("ARTIFACT_UNWRAP_ERROR", this.getArtifactType().getType()), e);
        }
    }

    public static ArtifactType valueOf(String artifactType) {
        return ArtifactType.valueOf(artifactType, false);
    }

    public static ArtifactType valueOf(String artifactType, boolean isDocument) {
        if (StringUtils.isEmpty((String)artifactType)) {
            return null;
        }
        if (ArtifactTypeEnum.hasEnum(artifactType)) {
            ArtifactTypeEnum artifactTypeEnum = ArtifactTypeEnum.valueOf(artifactType);
            return new ArtifactType(artifactTypeEnum, null);
        }
        ArtifactTypeEnum artifactTypeEnum = isDocument ? ArtifactTypeEnum.ExtendedDocument : ArtifactTypeEnum.ExtendedArtifactType;
        ArtifactType rval = new ArtifactType(artifactTypeEnum, null);
        rval.setExtendedType(artifactType);
        rval.setMimeType("application/octet-stream");
        return rval;
    }

    public static ArtifactType valueOf(String model, String type, Boolean isDocument) {
        ArtifactType artifactType = null;
        if ("ext".equals(model)) {
            ArtifactTypeEnum artifactTypeEnum = null;
            artifactTypeEnum = type.equals(ArtifactTypeEnum.ExtendedDocument.getType()) || !type.equals(ArtifactTypeEnum.ExtendedArtifactType.getType()) && isDocument != null && isDocument != false ? ArtifactTypeEnum.ExtendedDocument : ArtifactTypeEnum.ExtendedArtifactType;
            artifactType = new ArtifactType(artifactTypeEnum, null);
            artifactType.setExtendedType(type);
        } else {
            ArtifactTypeEnum artifactTypeEnum = ArtifactTypeEnum.valueOf(type);
            artifactType = new ArtifactType(artifactTypeEnum, null);
        }
        return artifactType;
    }

    public static ArtifactType valueOf(BaseArtifactType artifact) {
        ArtifactTypeEnum[] values;
        BaseArtifactEnum apiType = artifact.getArtifactType();
        if (apiType != null) {
            String extendedType;
            ArtifactType artifactType = ArtifactType.valueOf(apiType);
            if (DocumentArtifactType.class.isAssignableFrom(artifact.getClass())) {
                artifactType.setMimeType(((DocumentArtifactType)artifact).getContentType());
            }
            if (artifactType.isExtendedType()) {
                if (artifact.getOtherAttributes().keySet().contains(ArtificerConstants.SRAMP_CONTENT_TYPE_QNAME)) {
                    String contentTypeStr = (String)artifact.getOtherAttributes().get(ArtificerConstants.SRAMP_CONTENT_TYPE_QNAME);
                    artifactType.setMimeType(contentTypeStr);
                }
                String extendedDerived = (String)artifact.getOtherAttributes().get(ArtificerConstants.SRAMP_DERIVED_QNAME);
                artifactType.setExtendedDerivedType("true".equals(extendedDerived));
            }
            if (artifactType.getArtifactType() == ArtifactTypeEnum.ExtendedArtifactType) {
                extendedType = ((ExtendedArtifactType)artifact).getExtendedType();
                artifactType.setExtendedType(extendedType);
            } else if (artifactType.getArtifactType() == ArtifactTypeEnum.ExtendedDocument) {
                extendedType = ((ExtendedDocument)artifact).getExtendedType();
                artifactType.setExtendedType(extendedType);
            }
            return artifactType;
        }
        for (ArtifactTypeEnum artifactTypeEnum : values = ArtifactTypeEnum.values()) {
            if (!artifactTypeEnum.getTypeClass().equals(artifact.getClass())) continue;
            ArtifactType artifactType = new ArtifactType(artifactTypeEnum, null);
            if (artifactTypeEnum == ArtifactTypeEnum.ExtendedArtifactType || artifactTypeEnum == ArtifactTypeEnum.ExtendedDocument) {
                if (artifact.getOtherAttributes().keySet().contains(ArtificerConstants.SRAMP_CONTENT_TYPE_QNAME)) {
                    String contentTypeStr = (String)artifact.getOtherAttributes().get(ArtificerConstants.SRAMP_CONTENT_TYPE_QNAME);
                    artifactType.setMimeType(contentTypeStr);
                }
                String extendedType = artifact instanceof ExtendedArtifactType ? ((ExtendedArtifactType)artifact).getExtendedType() : ((ExtendedDocument)artifact).getExtendedType();
                String extendedDerived = (String)artifact.getOtherAttributes().get(ArtificerConstants.SRAMP_DERIVED_QNAME);
                artifactType.setExtendedType(extendedType);
                artifactType.setExtendedDerivedType("true".equals(extendedDerived));
            }
            return artifactType;
        }
        throw new RuntimeException(Messages.i18n.format("ARTIFACT_TYPE_FROM_CLASS_ERROR", artifact.getClass()));
    }

    public BaseArtifactType newArtifactInstance() {
        try {
            BaseArtifactType baseArtifactType = this.getArtifactType().getTypeClass().newInstance();
            baseArtifactType.setArtifactType(this.getArtifactType().getApiType());
            if (DocumentArtifactType.class.isAssignableFrom(baseArtifactType.getClass())) {
                ((DocumentArtifactType)baseArtifactType).setContentType(this.getMimeType());
            }
            if (this.getArtifactType() == ArtifactTypeEnum.ExtendedArtifactType) {
                baseArtifactType.getOtherAttributes().put(ArtificerConstants.SRAMP_CONTENT_TYPE_QNAME, this.getMimeType());
                ((ExtendedArtifactType)baseArtifactType).setExtendedType(this.getExtendedType());
            }
            if (this.getArtifactType() == ArtifactTypeEnum.ExtendedDocument) {
                baseArtifactType.getOtherAttributes().put(ArtificerConstants.SRAMP_CONTENT_TYPE_QNAME, this.getMimeType());
                ((ExtendedDocument)baseArtifactType).setExtendedType(this.getExtendedType());
            }
            return baseArtifactType;
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.i18n.format("ARTIFACT_INSTANTIATION_ERROR", this.getArtifactType().getTypeClass()), e);
        }
    }

    public static ArtifactType valueOf(BaseArtifactEnum apiType) {
        ArtifactTypeEnum[] values;
        for (ArtifactTypeEnum artifactType : values = ArtifactTypeEnum.values()) {
            if (artifactType.getApiType() != apiType) continue;
            return new ArtifactType(artifactType, null);
        }
        throw new RuntimeException(Messages.i18n.format("ARTIFACT_TYPE_FROM_APITYPE_ERROR", apiType.value()));
    }

    public ArtifactTypeEnum getArtifactType() {
        return this.artifactType;
    }

    public boolean isExtendedType() {
        return this.getArtifactType() == ArtifactTypeEnum.ExtendedArtifactType || this.getArtifactType() == ArtifactTypeEnum.ExtendedDocument;
    }

    public boolean isDocument() {
        if (this.isDerived()) {
            return false;
        }
        return this.getArtifactType().isDocument();
    }

    public boolean isDerived() {
        return this.getArtifactType().isDerived() || this.isExtendedDerivedType();
    }

    public void setArtifactType(ArtifactTypeEnum artifactType) {
        this.artifactType = artifactType;
    }

    public String getModel() {
        return this.getArtifactType().getModel();
    }

    public String getType() {
        if (this.getArtifactType() == ArtifactTypeEnum.ExtendedArtifactType || this.getArtifactType() == ArtifactTypeEnum.ExtendedDocument) {
            return this.getExtendedType();
        }
        return this.getArtifactType().getType();
    }

    public String getLabel() {
        return this.getArtifactType().getLabel();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String toString() {
        return String.format("/s-ramp/%1$s/%2$s (%3$s)", this.getArtifactType().getModel(), this.getArtifactType().getType(), this.getMimeType());
    }

    public void setExtendedType(String extendedType) {
        if (extendedType != null && !ArtifactType.isValid(extendedType)) {
            throw new RuntimeException(Messages.i18n.format("ArtifactType.InvalidExtendedType", extendedType));
        }
        this.extendedType = extendedType;
    }

    public String getExtendedType() {
        return this.extendedType;
    }

    public static ArtifactType valueOf(Artifact artifactWrapper, String hint) {
        ArtifactType type = null;
        if (hint != null) {
            String methodName = "get" + hint;
            try {
                Method method = artifactWrapper.getClass().getMethod(methodName, new Class[0]);
                Object o = method.invoke((Object)artifactWrapper, new Object[0]);
                if (o != null && BaseArtifactType.class.isAssignableFrom(o.getClass())) {
                    Class<?> artyClass = ((BaseArtifactType)o).getClass();
                    return ArtifactType.valueOf(artyClass);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (type == null) {
            Method[] methods = artifactWrapper.getClass().getMethods();
            try {
                for (Method method : methods) {
                    Object o;
                    if (!method.getName().startsWith("get") || (o = method.invoke((Object)artifactWrapper, new Object[0])) == null || !BaseArtifactType.class.isAssignableFrom(o.getClass())) continue;
                    Class<?> artyClass = ((BaseArtifactType)o).getClass();
                    return ArtifactType.valueOf(artyClass);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return type;
    }

    private static ArtifactType valueOf(Class<? extends BaseArtifactType> artyClass) {
        ArtifactType rval = null;
        for (ArtifactTypeEnum e : ArtifactTypeEnum.values()) {
            if (!e.getTypeClass().equals(artyClass)) continue;
            rval = new ArtifactType(e, null);
        }
        return rval;
    }

    protected boolean isExtendedDerivedType() {
        return this.extendedDerivedType;
    }

    public void setExtendedDerivedType(boolean extendedDerivedType) {
        this.extendedDerivedType = extendedDerivedType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactType == null ? 0 : this.artifactType.hashCode());
        result = 31 * result + (this.extendedType == null ? 0 : this.extendedType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactType other = (ArtifactType)obj;
        if (this.artifactType != other.artifactType) {
            return false;
        }
        return !(this.extendedType == null ? other.extendedType != null : !this.extendedType.equals(other.extendedType));
    }

    private static class ModelMime {
        public String extendedModel;
        public String mimeType;

        public ModelMime(String extendedModel, String mimeType) {
            this.extendedModel = extendedModel;
            this.mimeType = mimeType;
        }
    }
}

