/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.common;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.artificer.common.Version;
import org.overlord.commons.config.ConfigurationFactory;
import org.overlord.commons.config.JBossServer;

public class ArtificerConfig {
    private static Configuration configuration = null;

    public static String getBaseUrl(String requestUrl) {
        String baseUrl = null;
        if (requestUrl != null) {
            int index = requestUrl.lastIndexOf("/s-ramp/");
            if (index < 0) {
                index = requestUrl.lastIndexOf("/s-ramp");
            }
            if (index > 0) {
                baseUrl = requestUrl.substring(0, index);
            }
        }
        if (baseUrl == null) {
            baseUrl = JBossServer.getBaseUrl() + "/artificer-server";
        }
        return configuration.getString("artificer.config.baseurl", baseUrl);
    }

    public static boolean isAuditingEnabled() {
        return configuration.getBoolean("artificer.config.auditing.enabled", false);
    }

    public static boolean isDerivedArtifactAuditingEnabled() {
        return configuration.getBoolean("artificer.config.auditing.enabled-derived", false);
    }

    public static boolean isJmsEnabled() {
        return configuration.getBoolean("artificer.config.events.jms.enabled", false);
    }

    public static String getConfigProperty(String propertyName, String propertyDefault) {
        return configuration.getString(propertyName, propertyDefault);
    }

    public static boolean getConfigProperty(String propertyName, boolean propertyDefault) {
        return configuration.getBoolean(propertyName, propertyDefault);
    }

    public static String getJCRRepositoryName() {
        return ArtificerConfig.getConfigProperty("artificer.config.jcr.repository.name", "artificer");
    }

    public static String getMavenReadOnlyUsername() {
        return ArtificerConfig.getConfigProperty("artificer.config.maven.readonly-username", "mavenuser");
    }

    private static String getVersion() {
        return Version.get().getVersionString();
    }

    public static boolean containsKey(String key) {
        return configuration.containsKey(key);
    }

    public static boolean isSnapshotAllowed() {
        if (ArtificerConfig.isSnapshot()) {
            return true;
        }
        return ArtificerConfig.getConfigProperty("artificer.config.maven.allow-snapshots", false);
    }

    private static boolean isSnapshot() {
        String version = ArtificerConfig.getVersion();
        return StringUtils.isNotBlank((String)version) && version.contains("SNAPSHOT");
    }

    static {
        String configFile = System.getProperty("artificer.config.file.name");
        String refreshDelayStr = System.getProperty("artificer.config.file.refresh");
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        configuration = ConfigurationFactory.createConfig((String)configFile, (String)"artificer.properties", (Long)refreshDelay, null, null);
    }
}

