/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.devsvr;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.artificer.common.ArtificerConfig;

public class BasicAuthFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SimplePrincipal principal = new SimplePrincipal(ArtificerConfig.getMavenReadOnlyUsername());
        principal.addRole("admin." + ArtificerConfig.getJCRRepositoryName());
        chain.doFilter((ServletRequest)this.wrapRequest(request, principal), response);
    }

    private HttpServletRequest wrapRequest(ServletRequest request, final SimplePrincipal principal) {
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper((HttpServletRequest)request){

            public Principal getUserPrincipal() {
                return principal;
            }

            public String getRemoteUser() {
                return principal.getName();
            }

            public boolean isUserInRole(String role) {
                return principal.getRoles().contains(role);
            }
        };
        return wrapper;
    }

    public void destroy() {
    }

    private static class SimplePrincipal
    implements Principal {
        private String username;
        private Set<String> roles = new HashSet<String>();

        public SimplePrincipal(String username) {
            this.username = username;
        }

        @Override
        public String getName() {
            return this.username;
        }

        public void addRole(String role) {
            this.roles.add(role);
        }

        public Set<String> getRoles() {
            return this.roles;
        }
    }
}

