/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.devsvr;

import java.io.InputStream;
import java.security.Principal;
import java.util.EnumSet;
import java.util.EventListener;
import javax.security.auth.Subject;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.apache.commons.io.IOUtils;
import org.artificer.client.ArtificerAtomApiClient;
import org.artificer.client.ArtificerClientException;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.devsvr.ArtificerDevServerEnvironment;
import org.artificer.devsvr.BasicAuthFilter;
import org.artificer.devsvr.JettyArtificerApplication;
import org.artificer.repository.filter.ServletCredentialsFilter;
import org.artificer.server.ArtificerLifeCycle;
import org.artificer.server.atom.services.ArtificerApplication;
import org.artificer.server.filters.MavenRepositoryAuthFilter;
import org.artificer.server.mvn.services.MavenFacadeServlet;
import org.artificer.ui.client.shared.beans.ArtifactSummaryBean;
import org.artificer.ui.server.api.KeycloakBearerTokenAuthenticationProvider;
import org.artificer.ui.server.filters.LocaleFilter;
import org.artificer.ui.server.servlets.ArtifactCreateServlet;
import org.artificer.ui.server.servlets.ArtifactDownloadServlet;
import org.artificer.ui.server.servlets.ArtifactUploadServlet;
import org.artificer.ui.server.servlets.KeyCloakLogoutServlet;
import org.artificer.ui.server.servlets.OntologyDownloadServlet;
import org.artificer.ui.server.servlets.OntologyUploadServlet;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.commons.dev.server.DevServerEnvironment;
import org.overlord.commons.dev.server.ErraiDevServer;
import org.overlord.commons.dev.server.MultiDefaultServlet;
import org.overlord.commons.dev.server.discovery.ErraiWebAppModuleFromMavenDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.IModuleDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.WebAppModuleFromIDEDiscoveryStrategy;
import org.overlord.commons.gwt.server.filters.GWTCacheControlFilter;
import org.overlord.commons.gwt.server.filters.ResourceCacheControlFilter;

public class ArtificerDevServer
extends ErraiDevServer {
    public static void main(String[] args) throws Exception {
        ArtificerDevServer devServer = new ArtificerDevServer(args);
        devServer.enableDebug();
        devServer.go();
    }

    public ArtificerDevServer(String[] args) {
        super(args);
    }

    protected String getErraiModuleId() {
        return "artificer-ui";
    }

    protected void preConfig() {
        System.setProperty("hibernate.show_sql", "true");
        System.setProperty("hibernate.connection.driver_class", "org.h2.Driver");
        System.setProperty("hibernate.connection.url", "jdbc:h2:mem:dbHibernateTest;DB_CLOSE_DELAY=-1;MVCC=true");
        System.setProperty("hibernate.connection.username", "sa");
        System.setProperty("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        System.setProperty("hibernate.cache.use_second_level_cache", "false");
        System.setProperty("hibernate.cache.use_query_cache", "false");
        System.setProperty("hibernate.search.default.directory_provider", "ram");
        System.setProperty("artificer-ui.atom-api.authentication.provider", KeycloakBearerTokenAuthenticationProvider.class.getName());
        System.setProperty("overlord.resource-caching.disabled", "true");
        System.setProperty("artificer.config.events.jms.topics", "artificer/events/topic");
    }

    protected DevServerEnvironment createDevEnvironment() {
        return new ArtificerDevServerEnvironment(this.args);
    }

    protected void addModules(DevServerEnvironment environment) {
        environment.addModule("artificer-ui", new IModuleDiscoveryStrategy[]{new WebAppModuleFromIDEDiscoveryStrategy(ArtifactSummaryBean.class), new ErraiWebAppModuleFromMavenDiscoveryStrategy(ArtifactSummaryBean.class)});
    }

    protected void addModulesToJetty(DevServerEnvironment environment, ContextHandlerCollection handlers) throws Exception {
        String[] fileTypes;
        super.addModulesToJetty(environment, handlers);
        ServletContextHandler artificerUI = new ServletContextHandler(1);
        artificerUI.setSecurityHandler(this.createSecurityHandler(true));
        artificerUI.setContextPath("/artificer-ui");
        artificerUI.setWelcomeFiles(new String[]{"index.html"});
        artificerUI.setResourceBase(environment.getModuleDir("artificer-ui").getCanonicalPath());
        artificerUI.addFilter(GWTCacheControlFilter.class, "/app/*", EnumSet.of(DispatcherType.REQUEST));
        artificerUI.addFilter(GWTCacheControlFilter.class, "/rest/*", EnumSet.of(DispatcherType.REQUEST));
        artificerUI.addFilter(GWTCacheControlFilter.class, "/", EnumSet.of(DispatcherType.REQUEST));
        artificerUI.addFilter(GWTCacheControlFilter.class, "*.html", EnumSet.of(DispatcherType.REQUEST));
        artificerUI.addFilter(ResourceCacheControlFilter.class, "/css/*", EnumSet.of(DispatcherType.REQUEST));
        artificerUI.addFilter(ResourceCacheControlFilter.class, "/images/*", EnumSet.of(DispatcherType.REQUEST));
        artificerUI.addFilter(ResourceCacheControlFilter.class, "/js/*", EnumSet.of(DispatcherType.REQUEST));
        artificerUI.addFilter(LocaleFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        artificerUI.addServlet(new ServletHolder(ArtifactUploadServlet.class), "/app/services/artifactUpload");
        artificerUI.addServlet(new ServletHolder(ArtifactCreateServlet.class), "/app/services/artifactCreate");
        artificerUI.addServlet(new ServletHolder(ArtifactDownloadServlet.class), "/app/services/artifactDownload");
        artificerUI.addServlet(new ServletHolder(OntologyUploadServlet.class), "/app/services/ontologyUpload");
        artificerUI.addServlet(new ServletHolder(OntologyDownloadServlet.class), "/app/services/ontologyDownload");
        artificerUI.addServlet(new ServletHolder(KeyCloakLogoutServlet.class), "/app/services/logout");
        ServletHolder resteasyUIServlet = new ServletHolder((Servlet)new HttpServletDispatcher());
        resteasyUIServlet.setInitParameter("javax.ws.rs.Application", JettyArtificerApplication.class.getName());
        resteasyUIServlet.setInitParameter("resteasy.servlet.mapping.prefix", "/rest");
        artificerUI.addServlet(resteasyUIServlet, "/rest/*");
        ServletHolder resources = new ServletHolder((Servlet)new MultiDefaultServlet());
        resources.setInitParameter("resourceBase", "/");
        resources.setInitParameter("resourceBases", environment.getModuleDir("artificer-ui").getCanonicalPath());
        resources.setInitParameter("dirAllowed", "true");
        resources.setInitParameter("pathInfoOnly", "false");
        for (String fileType : fileTypes = new String[]{"html", "js", "css", "png", "gif"}) {
            artificerUI.addServlet(resources, "*." + fileType);
        }
        ServletContextHandler artificerServer = new ServletContextHandler(1);
        artificerServer.setSecurityHandler(this.createSecurityHandler(false));
        artificerServer.setContextPath("/artificer-server");
        artificerServer.addEventListener((EventListener)new ArtificerLifeCycle());
        ServletHolder resteasyServerServlet = new ServletHolder((Servlet)new HttpServletDispatcher());
        resteasyServerServlet.setInitParameter("javax.ws.rs.Application", ArtificerApplication.class.getName());
        artificerServer.addServlet(resteasyServerServlet, "/s-ramp/*");
        artificerServer.addServlet(resteasyServerServlet, "/artificer/*");
        ServletHolder mvnServlet = new ServletHolder((Servlet)new MavenFacadeServlet());
        artificerServer.addServlet(mvnServlet, "/maven/repository/*");
        artificerServer.addServlet(mvnServlet, "/maven/repository");
        artificerServer.addFilter(BasicAuthFilter.class, "/s-ramp/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("allowedIssuers", "/artificer-ui,/dtgov,/dtgov-ui");
        artificerServer.addFilter(BasicAuthFilter.class, "/artificer/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("allowedIssuers", "/artificer-ui,/dtgov,/dtgov-ui");
        artificerServer.addFilter(MavenRepositoryAuthFilter.class, "/maven/repository/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("allowedIssuers", "/artificer-ui,/dtgov,/dtgov-ui");
        artificerServer.addFilter(org.artificer.server.filters.LocaleFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        artificerServer.addFilter(ServletCredentialsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        handlers.addHandler((Handler)artificerUI);
        handlers.addHandler((Handler)artificerServer);
    }

    private SecurityHandler createSecurityHandler(boolean forUI) {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setSessionRenewedOnAuthentication(false);
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("artificer");
        if (forUI) {
            csh.addConstraintMapping(cm);
        }
        csh.setLoginService((LoginService)new HashLoginService(){

            public UserIdentity login(String username, Object credentials) {
                String[] roles;
                Credential credential = credentials instanceof Credential ? (Credential)credentials : Credential.getCredential((String)credentials.toString());
                MappedLoginService.KnownUser userPrincipal = new MappedLoginService.KnownUser(username, credential);
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)userPrincipal);
                subject.getPrivateCredentials().add(credential);
                for (String role : roles = new String[]{"user", "readonly", "readwrite", "admin"}) {
                    subject.getPrincipals().add((Principal)new MappedLoginService.RolePrincipal(role));
                }
                subject.setReadOnly();
                return this._identityService.newUserIdentity(subject, (Principal)userPrincipal, roles);
            }
        });
        return csh;
    }

    protected void postStart(DevServerEnvironment environment) throws Exception {
        System.out.println("----------  Seeding the Repository  ---------------");
        ArtificerAtomApiClient client = new ArtificerAtomApiClient("http://localhost:" + this.serverPort() + "/artificer-server", "seeder", "seeder", true);
        String seedType = System.getProperty("artificer-dev-server.seed-type", "none");
        if ("switchyard".equals(seedType)) {
            this.doSwitchYardSeed(client);
        } else if ("standard".equals(seedType)) {
            this.doStandardSeed(client);
        }
        System.out.println("----------  DONE  ---------------");
        System.out.println("Now try:  \n  http://localhost:" + this.serverPort() + "/artificer-ui/index.html");
        System.out.println("---------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStandardSeed(ArtificerAtomApiClient client) throws ArtificerClientException, ArtificerServerException {
        BaseArtifactType artifact;
        InputStream is = null;
        try {
            is = ArtificerDevServer.class.getResourceAsStream("colors.owl.xml");
            client.uploadOntology(is);
            System.out.println("Ontology 1 added");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        try {
            is = ArtificerDevServer.class.getResourceAsStream("regional.owl.xml");
            client.uploadOntology(is);
            System.out.println("Ontology 2 added");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        try {
            is = ArtificerDevServer.class.getResourceAsStream("sample.pdf");
            artifact = client.uploadArtifact(ArtifactType.Document(), is, "sample.pdf");
            artifact.setDescription("This is just a sample PDF file that is included in the dev server so that we have some content when we start up.");
            artifact.setVersion("1.0");
            client.updateArtifactMetaData(artifact);
            System.out.println("PDF added");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        try {
            is = ArtificerDevServer.class.getResourceAsStream("order.xml");
            artifact = client.uploadArtifact(ArtifactType.XmlDocument(), is, "order.xml");
            artifact.getClassifiedBy().add("http://www.example.org/colors.owl#Blue");
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"foo", (String)"bar");
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"angle", (String)"obtuse");
            client.updateArtifactMetaData(artifact);
            System.out.println("XML file added");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        try {
            is = ArtificerDevServer.class.getResourceAsStream("deriver.wsdl");
            artifact = client.uploadArtifact(ArtifactType.WsdlDocument(), is, "deriver.wsdl");
            artifact.getClassifiedBy().add("http://www.example.org/colors.owl#Red");
            artifact.getClassifiedBy().add("http://www.example.org/regional.owl#Asia");
            client.updateArtifactMetaData(artifact);
            System.out.println("WSDL added");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSwitchYardSeed(ArtificerAtomApiClient client) throws Exception {
        InputStream artifactsIS = ((Object)((Object)this)).getClass().getResourceAsStream("artifacts.jar");
        try {
            client.uploadArtifact(artifactsIS, "artifacts.jar");
            System.out.println("Added SwitchYard app (artifacts.jar)");
        }
        finally {
            IOUtils.closeQuietly((InputStream)artifactsIS);
        }
        InputStream orderConsumerIS = ((Object)((Object)this)).getClass().getResourceAsStream("order-consumer.jar");
        try {
            client.uploadArtifact(orderConsumerIS, "order-consumer.jar");
            System.out.println("Added SwitchYard app (order-consumer.jar)");
        }
        finally {
            IOUtils.closeQuietly((InputStream)artifactsIS);
        }
        InputStream orderServiceIS = ((Object)((Object)this)).getClass().getResourceAsStream("order-service.jar");
        try {
            client.uploadArtifact(orderServiceIS, "order-service.jar");
            System.out.println("Added SwitchYard app (order-service.jar)");
        }
        finally {
            IOUtils.closeQuietly((InputStream)artifactsIS);
        }
    }
}

