/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.integration.kie.artifacttypedetector;

import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;
import org.artificer.integration.ArchiveContext;
import org.artificer.integration.artifacttypedetector.AbstractArtifactTypeDetector;

public class KieArtifactTypeDetector
extends AbstractArtifactTypeDetector {
    public ArtifactType detect(ArtifactContent content) {
        if (content.getFilename().equals("kmodule.xml")) {
            return ArtifactType.valueOf((String)"KieXmlDocument", (boolean)true);
        }
        if (content.getFilename().endsWith(".bpmn") || content.getFilename().endsWith(".bpmn2")) {
            return ArtifactType.valueOf((String)"BpmnDocument", (boolean)true);
        }
        if (content.getFilename().endsWith(".drl")) {
            return ArtifactType.valueOf((String)"DroolsDocument", (boolean)true);
        }
        return null;
    }

    public ArtifactType detect(ArtifactContent content, ArchiveContext archiveContext) {
        if (archiveContext.isExpandedFromArchive()) {
            return this.detect(content);
        }
        if (archiveContext.hasArchiveEntry("META-INF/kmodule.xml")) {
            return ArtifactType.valueOf((String)"KieJarArchive", (boolean)true);
        }
        return null;
    }

    public boolean allowExpansionFromArchive(ArtifactContent content, ArchiveContext archiveContext) {
        String filename;
        if (archiveContext.isExtendedTypeArchive("KieJarArchive") && ((filename = content.getFilename()).endsWith(".bpmn") || filename.endsWith(".bpmn2") || filename.endsWith(".drl"))) {
            return true;
        }
        return super.allowExpansionFromArchive(content, archiveContext);
    }

    public int getPriority() {
        return 2;
    }
}

