/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.integration.teiid.model;

import org.artificer.integration.teiid.Messages;
import org.artificer.integration.teiid.model.Describable;
import org.artificer.integration.teiid.model.Propertied;
import org.artificer.integration.teiid.model.TeiidArtifactType;
import org.artificer.integration.teiid.model.TeiidExtendedType;
import org.artificer.integration.teiid.model.TeiidRelationshipType;

public final class VdbManifest {
    public static final TeiidExtendedType ARTIFACT_TYPE = TeiidArtifactType.VDB_MANIFEST;
    public static final TeiidRelationshipType CONTAINS_RELATIONSHIP = VdbManifestRelationshipType.CONTAINS;
    public static final String FILE_NAME = "vdb.xml";
    public static final String PATH = "META-INF/vdb.xml";
    private static final String PREFIX = "TeiidVdb";

    static enum VdbManifestRelationshipType implements TeiidRelationshipType
    {
        CONTAINS("Contains"),
        DATA_POLICY_TO_PERMISSIONS("DataPolicyPermissions"),
        PERMISSION_TO_DATA_POLICY("PermissionDataPolicy"),
        SCHEMA_TO_SOURCES("SchemaSources"),
        SCHEMA_TO_VALIDATION_ERRORS("SchemaValidationErrors"),
        SOURCE_TO_SCHEMAS("SourceSchemas"),
        SOURCE_TO_TRANSLATOR("SourceTranslator"),
        TRANSLATOR_TO_SOURCES("TranslatorSources"),
        VALIDATION_ERROR_TO_SOURCE("ValidationErrorSource");

        private final String relationshipType;

        private VdbManifestRelationshipType(String relationshipType) {
            this.relationshipType = VdbManifest.PREFIX + relationshipType;
        }

        @Override
        public TeiidRelationshipType convert(String proposedRelationshipType) {
            for (VdbManifestRelationshipType type : VdbManifestRelationshipType.values()) {
                if (!type.relationshipType().equals(proposedRelationshipType)) continue;
                return type;
            }
            throw new IllegalArgumentException(Messages.I18N.format("invalidVdbRelationshipType", new Object[]{proposedRelationshipType}));
        }

        @Override
        public boolean isValid(String proposedRelationshipType) {
            for (VdbManifestRelationshipType type : VdbManifestRelationshipType.values()) {
                if (!type.relationshipType().equals(proposedRelationshipType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String relationshipType() {
            return this.relationshipType;
        }
    }

    static enum VdbManifestExtendedType implements TeiidExtendedType
    {
        DATA_POLICY("DataPolicy"),
        ENTRY("Entry"),
        IMPORT_VDB("ImportVdb"),
        PERMISSION("Permission"),
        SCHEMA("Schema"),
        SOURCE("Source"),
        TRANSLATOR("Translator"),
        VALIDATION_ERROR("ValidationError");

        private final String extendedType;

        private VdbManifestExtendedType(String extendedType) {
            this.extendedType = VdbManifest.PREFIX + extendedType;
        }

        @Override
        public TeiidExtendedType convert(String proposedExtendedType) {
            for (VdbManifestExtendedType type : VdbManifestExtendedType.values()) {
                if (!type.extendedType().equals(proposedExtendedType)) continue;
                return type;
            }
            throw new IllegalArgumentException(Messages.I18N.format("invalidVdbManifestExtendedType", new Object[]{proposedExtendedType}));
        }

        @Override
        public String extendedType() {
            return this.extendedType;
        }

        @Override
        public boolean isValid(String proposedExtendedType) {
            for (VdbManifestExtendedType type : VdbManifestExtendedType.values()) {
                if (!type.extendedType().equals(proposedExtendedType)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface PropertyId
    extends Describable.PropertyId,
    Propertied.XmlId {
        public static final String PREVIEW = "preview";
        public static final String USE_CONNECTOR_METADATA = "UseConnectorMetadata";
        public static final String VERSION = "vdbVersion";
    }

    public static interface ManifestId
    extends Describable.XmlId {
        public static final String DATA_POLICY = "data-role";
        public static final String ENTRY = "entry";
        public static final String IMPORT_VDB = "import-vdb";
        public static final String NAME = "name";
        public static final String SCHEMA = "model";
        public static final String TRANSLATOR = "translator";
        public static final String VALIDATION_ERROR = "validation-error";
        public static final String VDB_ELEMENT = "vdb";
        public static final String VERSION = "version";
    }
}

