/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.integration.artifactbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.artificer.integration.artifactbuilder.RelationshipContext;
import org.artificer.integration.artifactbuilder.RelationshipSource;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;

public abstract class CriteriaQueryRelationshipSource
implements RelationshipSource {
    protected Target target;
    protected final Collection targetCollection;
    protected final String model;
    protected final String[] types;

    public CriteriaQueryRelationshipSource(Target target, Collection targetCollection, String model, String ... types) {
        this.target = target;
        this.targetCollection = targetCollection;
        this.model = model;
        this.types = types;
    }

    @Override
    public void build(RelationshipContext context) {
        if (this.target == null) {
            this.target = new Target();
            if (this.targetCollection != null) {
                this.targetCollection.add(this.target);
            }
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        this.addCriteria(criteria);
        ArrayList<BaseArtifactType> artifacts = new ArrayList<BaseArtifactType>();
        for (String type : this.types) {
            Collection<BaseArtifactType> results = context.findArtifacts(this.model, type, criteria);
            artifacts.addAll(results);
        }
        Collections.sort(artifacts, new CreationDateComparator());
        if (!artifacts.isEmpty()) {
            BaseArtifactType artifact = (BaseArtifactType)artifacts.iterator().next();
            this.target.setValue(artifact.getUuid());
        } else {
            this.notFound();
            if (this.targetCollection != null) {
                this.targetCollection.remove(this.target);
            }
            this.target = null;
        }
    }

    protected abstract void addCriteria(Map<String, String> var1);

    protected void notFound() {
    }

    private static class CreationDateComparator
    implements Comparator<BaseArtifactType> {
        private CreationDateComparator() {
        }

        @Override
        public int compare(BaseArtifactType o1, BaseArtifactType o2) {
            return o2.getCreatedTimestamp().compare(o1.getCreatedTimestamp());
        }
    }
}

