/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.integration.artifactbuilder;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.query.xpath.StaticNamespaceContext;
import org.artificer.integration.artifactbuilder.AbstractArtifactBuilder;
import org.artificer.integration.artifactbuilder.ArtifactBuilder;
import org.artificer.integration.artifactbuilder.RelationshipContext;
import org.artificer.integration.artifactbuilder.RelationshipSource;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlArtifactBuilder
extends AbstractArtifactBuilder {
    protected final List<RelationshipSource> relationshipSources = new ArrayList<RelationshipSource>();
    protected InputStream contentStream;
    protected Element rootElement;
    protected XPath xpath;

    @Override
    public ArtifactBuilder buildArtifacts(BaseArtifactType primaryArtifact, ArtifactContent artifactContent) throws IOException {
        super.buildArtifacts(primaryArtifact, artifactContent);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(this.getContentStream());
            this.rootElement = document.getDocumentElement();
            if (primaryArtifact instanceof XmlDocument) {
                String encoding = document.getXmlEncoding();
                if (StringUtils.isBlank((String)encoding)) {
                    encoding = "UTF-8";
                }
                ((XmlDocument)primaryArtifact).setContentEncoding(encoding);
            }
            XPathFactory xPathfactory = XPathFactory.newInstance();
            this.xpath = xPathfactory.newXPath();
            StaticNamespaceContext nsCtx = new StaticNamespaceContext();
            this.configureNamespaceMappings(nsCtx);
            this.xpath.setNamespaceContext((NamespaceContext)nsCtx);
            this.derive();
            for (BaseArtifactType derivedArtifact : this.getDerivedArtifacts()) {
                if (derivedArtifact instanceof DerivedArtifactType) {
                    DerivedArtifactType dat = (DerivedArtifactType)derivedArtifact;
                    if (dat.getRelatedDocument() != null) continue;
                    DocumentArtifactTarget related = new DocumentArtifactTarget();
                    related.setValue(primaryArtifact.getUuid());
                    related.setArtifactType(DocumentArtifactEnum.fromValue((BaseArtifactEnum)primaryArtifact.getArtifactType()));
                    dat.setRelatedDocument(related);
                    continue;
                }
                Relationship genericRelationship = ArtificerModelUtils.getGenericRelationship((BaseArtifactType)derivedArtifact, (String)"relatedDocument");
                if (genericRelationship != null) continue;
                ArtificerModelUtils.addGenericRelationship((BaseArtifactType)derivedArtifact, (String)"relatedDocument", (String)primaryArtifact.getUuid());
            }
            return this;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public ArtifactBuilder buildRelationships(RelationshipContext context) throws IOException {
        for (RelationshipSource relationshipSource : this.relationshipSources) {
            relationshipSource.build(context);
        }
        return this;
    }

    protected void derive() throws IOException {
    }

    protected void configureNamespaceMappings(StaticNamespaceContext namespaceContext) {
    }

    protected Object query(Element element, String query, QName returnType) throws XPathExpressionException {
        XPathExpression expr = this.xpath.compile(query);
        return expr.evaluate(element, returnType);
    }
}

