/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.integration.artifactbuilder;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.artificer.common.ArtifactTypeEnum;
import org.artificer.common.query.xpath.StaticNamespaceContext;
import org.artificer.integration.artifactbuilder.NamespaceRelationshipSource;
import org.artificer.integration.artifactbuilder.QNameRelationshipSource;
import org.artificer.integration.artifactbuilder.XsdDocumentArtifactBuilder;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Binding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationFault;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationFaultEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationFaultTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationInputEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationInputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationOutputEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationOutputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclarationEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclarationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Fault;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.FaultEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.FaultTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Message;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.MessageEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.MessageTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Operation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInputEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutputEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Part;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PartEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PartTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Port;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortTypeEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortTypeTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapAddress;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapBinding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocumentEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocumentTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlExtensionEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlExtensionTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlService;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdTypeEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdTypeTarget;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WsdlDocumentArtifactBuilder
extends XsdDocumentArtifactBuilder {
    private String targetNS;

    @Override
    protected void configureNamespaceMappings(StaticNamespaceContext namespaceContext) {
        super.configureNamespaceMappings(namespaceContext);
        namespaceContext.addMapping("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        namespaceContext.addMapping("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
    }

    @Override
    protected void derive() throws IOException {
        this.targetNS = this.rootElement.getAttribute("targetNamespace");
        if (this.getPrimaryArtifact() instanceof WsdlDocument) {
            ((WsdlDocument)this.getPrimaryArtifact()).setTargetNamespace(this.targetNS);
        }
        try {
            NodeList schemas = (NodeList)this.query(this.rootElement, "./wsdl:types/xsd:schema", XPathConstants.NODESET);
            for (int idx = 0; idx < schemas.getLength(); ++idx) {
                Element schema = (Element)schemas.item(idx);
                this.deriveXsd(schema);
                String xsdTargetNS = schema.getAttribute("targetNamespace");
                this.processImportedXsds(((WsdlDocument)this.getPrimaryArtifact()).getImportedXsds(), schema, xsdTargetNS);
                this.processIncludedXsds(((WsdlDocument)this.getPrimaryArtifact()).getIncludedXsds(), schema, xsdTargetNS);
                this.processRedefinedXsds(((WsdlDocument)this.getPrimaryArtifact()).getRedefinedXsds(), schema, xsdTargetNS);
            }
            this.processWsdlImports();
            this.processMessages();
            this.processPortTypes();
            this.processBindings();
            this.processServices();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void processMessages() throws XPathExpressionException {
        NodeList messages = (NodeList)this.query(this.rootElement, "./wsdl:message", XPathConstants.NODESET);
        for (int idx = 0; idx < messages.getLength(); ++idx) {
            Element messageElem = (Element)messages.item(idx);
            if (!messageElem.hasAttribute("name")) continue;
            String name = messageElem.getAttribute("name");
            Message message = new Message();
            message.setUuid(UUID.randomUUID().toString());
            message.setArtifactType(BaseArtifactEnum.MESSAGE);
            message.setName(name);
            message.setNamespace(this.targetNS);
            message.setNCName(name);
            this.derivedArtifacts.add((BaseArtifactType)message);
            Collection<Part> parts = this.processParts(messageElem);
            for (Part part : parts) {
                PartTarget target = new PartTarget();
                target.setValue(part.getUuid());
                target.setArtifactType(PartEnum.PART);
                message.getPart().add(target);
            }
        }
    }

    private Collection<Part> processParts(Element messageElem) throws XPathExpressionException {
        LinkedList<Part> rval = new LinkedList<Part>();
        NodeList parts = (NodeList)this.query(messageElem, "./wsdl:part", XPathConstants.NODESET);
        for (int idx = 0; idx < parts.getLength(); ++idx) {
            QName qname;
            String encodedQName;
            Element partElem = (Element)parts.item(idx);
            if (!partElem.hasAttribute("name")) continue;
            String name = partElem.getAttribute("name");
            Part part = new Part();
            part.setUuid(UUID.randomUUID().toString());
            part.setArtifactType(BaseArtifactEnum.PART);
            part.setName(name);
            part.setNamespace(this.targetNS);
            part.setNCName(name);
            this.derivedArtifacts.add((BaseArtifactType)part);
            rval.add(part);
            if (partElem.hasAttribute("element")) {
                encodedQName = partElem.getAttribute("element");
                qname = this.resolveQName(partElem, this.targetNS, encodedQName);
                ElementDeclaration elementRef = this.derivedArtifacts.lookupElement(qname);
                ElementDeclarationTarget elementTarget = new ElementDeclarationTarget();
                elementTarget.setArtifactType(ElementDeclarationEnum.ELEMENT_DECLARATION);
                if (elementRef != null) {
                    elementTarget.setValue(elementRef.getUuid());
                } else {
                    this.relationshipSources.add(new QNameRelationshipSource(qname, (Target)elementTarget, null, ArtifactTypeEnum.ElementDeclaration.getModel(), ArtifactTypeEnum.ElementDeclaration.getType()));
                }
                part.setElement(elementTarget);
                continue;
            }
            if (!partElem.hasAttribute("type")) continue;
            encodedQName = partElem.getAttribute("type");
            qname = this.resolveQName(partElem, this.targetNS, encodedQName);
            XsdType typeRef = this.derivedArtifacts.lookupType(qname);
            XsdTypeTarget typeTarget = new XsdTypeTarget();
            typeTarget.setArtifactType(XsdTypeEnum.XSD_TYPE);
            if (typeRef != null) {
                typeTarget.setValue(typeRef.getUuid());
            } else {
                this.relationshipSources.add(new QNameRelationshipSource(qname, (Target)typeTarget, null, ArtifactTypeEnum.XsdType.getModel(), ArtifactTypeEnum.SimpleTypeDeclaration.getType(), ArtifactTypeEnum.ComplexTypeDeclaration.getType()));
            }
            part.setType(typeTarget);
        }
        return rval;
    }

    private void processPortTypes() throws XPathExpressionException {
        NodeList portTypes = (NodeList)this.query(this.rootElement, "./wsdl:portType", XPathConstants.NODESET);
        for (int idx = 0; idx < portTypes.getLength(); ++idx) {
            Element portTypeElem = (Element)portTypes.item(idx);
            if (!portTypeElem.hasAttribute("name")) continue;
            String name = portTypeElem.getAttribute("name");
            PortType portType = new PortType();
            portType.setUuid(UUID.randomUUID().toString());
            portType.setArtifactType(BaseArtifactEnum.PORT_TYPE);
            portType.setName(name);
            portType.setNamespace(this.targetNS);
            portType.setNCName(name);
            this.derivedArtifacts.add((BaseArtifactType)portType);
            Collection<Operation> operations = this.processOperations(portTypeElem);
            for (Operation operation : operations) {
                OperationTarget target = new OperationTarget();
                target.setValue(operation.getUuid());
                target.setArtifactType(OperationEnum.OPERATION);
                portType.getOperation().add(target);
            }
        }
    }

    private Collection<Operation> processOperations(Element portTypeElem) throws XPathExpressionException {
        LinkedList<Operation> rval = new LinkedList<Operation>();
        NodeList operations = (NodeList)this.query(portTypeElem, "./wsdl:operation", XPathConstants.NODESET);
        for (int idx = 0; idx < operations.getLength(); ++idx) {
            OperationInputTarget target;
            Element operationElem = (Element)operations.item(idx);
            if (!operationElem.hasAttribute("name")) continue;
            String name = operationElem.getAttribute("name");
            Operation operation = new Operation();
            operation.setUuid(UUID.randomUUID().toString());
            operation.setArtifactType(BaseArtifactEnum.OPERATION);
            operation.setName(name);
            operation.setNamespace(this.targetNS);
            operation.setNCName(name);
            this.derivedArtifacts.add((BaseArtifactType)operation);
            rval.add(operation);
            OperationInput operationInput = this.processOperationInput(operationElem);
            OperationOutput operationOutput = this.processOperationOutput(operationElem);
            Collection<Fault> operationFaults = this.processOperationFaults(operationElem);
            if (operationInput != null) {
                target = new OperationInputTarget();
                target.setValue(operationInput.getUuid());
                target.setArtifactType(OperationInputEnum.OPERATION_INPUT);
                operation.setInput(target);
            }
            if (operationOutput != null) {
                target = new OperationOutputTarget();
                target.setValue(operationOutput.getUuid());
                target.setArtifactType(OperationOutputEnum.OPERATION_OUTPUT);
                operation.setOutput((OperationOutputTarget)target);
            }
            if (operationFaults == null) continue;
            for (Fault fault : operationFaults) {
                FaultTarget target2 = new FaultTarget();
                target2.setValue(fault.getUuid());
                target2.setArtifactType(FaultEnum.FAULT);
                operation.getFault().add(target2);
            }
        }
        return rval;
    }

    private OperationInput processOperationInput(Element operationElem) throws XPathExpressionException {
        OperationInput rval = null;
        Element inputElem = (Element)this.query(operationElem, "./wsdl:input", XPathConstants.NODE);
        if (inputElem != null) {
            OperationInput input = new OperationInput();
            input.setUuid(UUID.randomUUID().toString());
            input.setArtifactType(BaseArtifactEnum.OPERATION_INPUT);
            String name = null;
            this.derivedArtifacts.add((BaseArtifactType)input);
            if (inputElem.hasAttribute("message")) {
                String encodedMsgQname = inputElem.getAttribute("message");
                QName msgQname = this.resolveQName(inputElem, this.targetNS, encodedMsgQname);
                name = msgQname.getLocalPart();
                Message message = this.derivedArtifacts.lookupMessage(msgQname);
                MessageTarget target = new MessageTarget();
                target.setArtifactType(MessageEnum.MESSAGE);
                if (message != null) {
                    target.setValue(message.getUuid());
                } else {
                    this.relationshipSources.add(new QNameRelationshipSource(msgQname, (Target)target, null, ArtifactTypeEnum.Message.getModel(), ArtifactTypeEnum.Message.getType()));
                }
                input.setMessage(target);
            }
            if (inputElem.hasAttribute("name")) {
                name = inputElem.getAttribute("name");
                input.setNCName(name);
            }
            input.setName(name);
            input.setNamespace(this.targetNS);
            rval = input;
        }
        return rval;
    }

    private OperationOutput processOperationOutput(Element operationElem) throws XPathExpressionException {
        OperationOutput rval = null;
        Element outputElem = (Element)this.query(operationElem, "./wsdl:output", XPathConstants.NODE);
        if (outputElem != null) {
            OperationOutput output = new OperationOutput();
            output.setUuid(UUID.randomUUID().toString());
            output.setArtifactType(BaseArtifactEnum.OPERATION_OUTPUT);
            String name = null;
            this.derivedArtifacts.add((BaseArtifactType)output);
            if (outputElem.hasAttribute("message")) {
                String encodedMsgQname = outputElem.getAttribute("message");
                QName msgQname = this.resolveQName(outputElem, this.targetNS, encodedMsgQname);
                name = msgQname.getLocalPart();
                Message message = this.derivedArtifacts.lookupMessage(msgQname);
                MessageTarget target = new MessageTarget();
                target.setArtifactType(MessageEnum.MESSAGE);
                if (message != null) {
                    target.setValue(message.getUuid());
                } else {
                    this.relationshipSources.add(new QNameRelationshipSource(msgQname, (Target)target, null, ArtifactTypeEnum.Message.getModel(), ArtifactTypeEnum.Message.getType()));
                }
                output.setMessage(target);
            }
            if (outputElem.hasAttribute("name")) {
                name = outputElem.getAttribute("name");
                output.setNCName(name);
            }
            output.setName(name);
            output.setNamespace(this.targetNS);
            rval = output;
        }
        return rval;
    }

    private Collection<Fault> processOperationFaults(Element operationElem) throws XPathExpressionException {
        LinkedList<Fault> rval = new LinkedList<Fault>();
        NodeList faults = (NodeList)this.query(operationElem, "./wsdl:fault", XPathConstants.NODESET);
        for (int idx = 0; idx < faults.getLength(); ++idx) {
            Element faultElem = (Element)faults.item(idx);
            Fault fault = new Fault();
            fault.setUuid(UUID.randomUUID().toString());
            fault.setArtifactType(BaseArtifactEnum.FAULT);
            String name = null;
            this.derivedArtifacts.add((BaseArtifactType)fault);
            rval.add(fault);
            if (faultElem.hasAttribute("message")) {
                String encodedMsgQname = faultElem.getAttribute("message");
                QName msgQname = this.resolveQName(faultElem, this.targetNS, encodedMsgQname);
                name = msgQname.getLocalPart();
                Message message = this.derivedArtifacts.lookupMessage(msgQname);
                MessageTarget target = new MessageTarget();
                target.setArtifactType(MessageEnum.MESSAGE);
                if (message != null) {
                    target.setValue(message.getUuid());
                } else {
                    this.relationshipSources.add(new QNameRelationshipSource(msgQname, (Target)target, null, ArtifactTypeEnum.Message.getModel(), ArtifactTypeEnum.Message.getType()));
                }
                fault.setMessage(target);
            }
            if (faultElem.hasAttribute("name")) {
                name = faultElem.getAttribute("name");
                fault.setNCName(name);
            }
            fault.setName(name);
            fault.setNamespace(this.targetNS);
        }
        return rval;
    }

    private void processBindings() throws XPathExpressionException {
        NodeList bindings = (NodeList)this.query(this.rootElement, "./wsdl:binding", XPathConstants.NODESET);
        for (int idx = 0; idx < bindings.getLength(); ++idx) {
            Element bindingElem = (Element)bindings.item(idx);
            if (!bindingElem.hasAttribute("name")) continue;
            String name = bindingElem.getAttribute("name");
            Binding binding = new Binding();
            binding.setUuid(UUID.randomUUID().toString());
            binding.setArtifactType(BaseArtifactEnum.BINDING);
            binding.setName(name);
            binding.setNamespace(this.targetNS);
            binding.setNCName(name);
            this.derivedArtifacts.add((BaseArtifactType)binding);
            PortType portType = null;
            if (bindingElem.hasAttribute("type")) {
                String portTypeEncodedQName = bindingElem.getAttribute("type");
                QName portTypeQName = this.resolveQName(bindingElem, this.targetNS, portTypeEncodedQName);
                portType = this.derivedArtifacts.lookupPortType(portTypeQName);
                PortTypeTarget target = new PortTypeTarget();
                target.setArtifactType(PortTypeEnum.PORT_TYPE);
                if (portType != null) {
                    target.setValue(portType.getUuid());
                } else {
                    this.relationshipSources.add(new QNameRelationshipSource(portTypeQName, (Target)target, null, ArtifactTypeEnum.PortType.getModel(), ArtifactTypeEnum.PortType.getType()));
                }
                binding.setPortType(target);
            }
            Collection<BindingOperation> bindingOperations = this.processBindingOperations(bindingElem, portType);
            for (BindingOperation bindingOperation : bindingOperations) {
                BindingOperationTarget target = new BindingOperationTarget();
                target.setValue(bindingOperation.getUuid());
                target.setArtifactType(BindingOperationEnum.BINDING_OPERATION);
                binding.getBindingOperation().add(target);
            }
            NodeList soapBindings = (NodeList)this.query(bindingElem, "./soap:binding", XPathConstants.NODESET);
            for (int jdx = 0; jdx < bindings.getLength(); ++jdx) {
                Element soapBindingElem = (Element)soapBindings.item(jdx);
                if (soapBindingElem == null) continue;
                SoapBinding soapBinding = new SoapBinding();
                soapBinding.setUuid(UUID.randomUUID().toString());
                soapBinding.setArtifactType(BaseArtifactEnum.SOAP_BINDING);
                soapBinding.setName("soap:binding");
                soapBinding.setNamespace(soapBindingElem.getNamespaceURI());
                soapBinding.setNCName(soapBindingElem.getLocalName());
                soapBinding.setStyle(soapBindingElem.getAttribute("style"));
                soapBinding.setTransport(soapBindingElem.getAttribute("transport"));
                this.derivedArtifacts.add((BaseArtifactType)soapBinding);
                WsdlExtensionTarget target = new WsdlExtensionTarget();
                target.setArtifactType(WsdlExtensionEnum.WSDL_EXTENSION);
                target.setValue(soapBinding.getUuid());
                binding.getExtension().add(target);
            }
        }
    }

    private Collection<BindingOperation> processBindingOperations(Element bindingElem, PortType portType) throws XPathExpressionException {
        LinkedList<BindingOperation> rval = new LinkedList<BindingOperation>();
        NodeList bindingOperations = (NodeList)this.query(bindingElem, "./wsdl:operation", XPathConstants.NODESET);
        for (int idx = 0; idx < bindingOperations.getLength(); ++idx) {
            BindingOperationInputTarget target;
            Element bindingOperationElem = (Element)bindingOperations.item(idx);
            if (!bindingOperationElem.hasAttribute("name")) continue;
            String name = bindingOperationElem.getAttribute("name");
            BindingOperation bindingOperation = new BindingOperation();
            bindingOperation.setUuid(UUID.randomUUID().toString());
            bindingOperation.setArtifactType(BaseArtifactEnum.BINDING_OPERATION);
            bindingOperation.setName(name);
            bindingOperation.setNamespace(this.targetNS);
            bindingOperation.setNCName(name);
            this.derivedArtifacts.add((BaseArtifactType)bindingOperation);
            rval.add(bindingOperation);
            if (portType != null) {
                QName portTypeQName = new QName(portType.getNamespace(), portType.getName());
                Operation operation = this.derivedArtifacts.lookupOperation(portTypeQName, name);
                OperationTarget opTarget = new OperationTarget();
                opTarget.setValue(operation.getUuid());
                opTarget.setArtifactType(OperationEnum.OPERATION);
                bindingOperation.setOperation(opTarget);
            }
            BindingOperationInput bindingOperationInput = this.processBindingOperationInput(bindingOperationElem);
            BindingOperationOutput bindingOperationOutput = this.processBindingOperationOutput(bindingOperationElem);
            Collection<BindingOperationFault> bindingOperationFaults = this.processBindingOperationFaults(bindingOperationElem);
            if (bindingOperationInput != null) {
                target = new BindingOperationInputTarget();
                target.setValue(bindingOperationInput.getUuid());
                target.setArtifactType(BindingOperationInputEnum.BINDING_OPERATION_INPUT);
                bindingOperation.setInput(target);
            }
            if (bindingOperationOutput != null) {
                target = new BindingOperationOutputTarget();
                target.setValue(bindingOperationOutput.getUuid());
                target.setArtifactType(BindingOperationOutputEnum.BINDING_OPERATION_OUTPUT);
                bindingOperation.setOutput((BindingOperationOutputTarget)target);
            }
            for (BindingOperationFault fault : bindingOperationFaults) {
                BindingOperationFaultTarget target2 = new BindingOperationFaultTarget();
                target2.setValue(fault.getUuid());
                target2.setArtifactType(BindingOperationFaultEnum.BINDING_OPERATION_FAULT);
                bindingOperation.getFault().add(target2);
            }
        }
        return rval;
    }

    private BindingOperationInput processBindingOperationInput(Element operationElem) throws XPathExpressionException {
        BindingOperationInput rval = null;
        Element inputElem = (Element)this.query(operationElem, "./wsdl:input", XPathConstants.NODE);
        if (inputElem != null) {
            BindingOperationInput bindingOperationInput = new BindingOperationInput();
            bindingOperationInput.setUuid(UUID.randomUUID().toString());
            bindingOperationInput.setArtifactType(BaseArtifactEnum.BINDING_OPERATION_INPUT);
            String name = "wsdl:input";
            if (inputElem.hasAttribute("name")) {
                name = inputElem.getAttribute("name");
                bindingOperationInput.setNCName(name);
            }
            bindingOperationInput.setName(name);
            bindingOperationInput.setNamespace(this.targetNS);
            this.derivedArtifacts.add((BaseArtifactType)bindingOperationInput);
            rval = bindingOperationInput;
        }
        return rval;
    }

    private BindingOperationOutput processBindingOperationOutput(Element operationElem) throws XPathExpressionException {
        BindingOperationOutput rval = null;
        Element outputElem = (Element)this.query(operationElem, "./wsdl:output", XPathConstants.NODE);
        if (outputElem != null) {
            BindingOperationOutput bindingOperationOutput = new BindingOperationOutput();
            bindingOperationOutput.setUuid(UUID.randomUUID().toString());
            bindingOperationOutput.setArtifactType(BaseArtifactEnum.BINDING_OPERATION_OUTPUT);
            String name = "wsdl:output";
            if (outputElem.hasAttribute("name")) {
                name = outputElem.getAttribute("name");
                bindingOperationOutput.setNCName(name);
            }
            bindingOperationOutput.setName(name);
            bindingOperationOutput.setNamespace(this.targetNS);
            this.derivedArtifacts.add((BaseArtifactType)bindingOperationOutput);
            rval = bindingOperationOutput;
        }
        return rval;
    }

    private Collection<BindingOperationFault> processBindingOperationFaults(Element operationElem) throws XPathExpressionException {
        LinkedList<BindingOperationFault> rval = new LinkedList<BindingOperationFault>();
        NodeList faults = (NodeList)this.query(operationElem, "./wsdl:fault", XPathConstants.NODESET);
        for (int idx = 0; idx < faults.getLength(); ++idx) {
            Element faultElem = (Element)faults.item(idx);
            BindingOperationFault bindingOperationFault = new BindingOperationFault();
            bindingOperationFault.setUuid(UUID.randomUUID().toString());
            bindingOperationFault.setArtifactType(BaseArtifactEnum.BINDING_OPERATION_FAULT);
            String name = "wsdl:fault";
            if (faultElem.hasAttribute("name")) {
                name = faultElem.getAttribute("name");
                bindingOperationFault.setNCName(name);
            }
            bindingOperationFault.setName(name);
            bindingOperationFault.setNamespace(this.targetNS);
            this.derivedArtifacts.add((BaseArtifactType)bindingOperationFault);
            rval.add(bindingOperationFault);
        }
        return rval;
    }

    private void processServices() throws XPathExpressionException {
        NodeList services = (NodeList)this.query(this.rootElement, "./wsdl:service", XPathConstants.NODESET);
        for (int idx = 0; idx < services.getLength(); ++idx) {
            Element serviceElem = (Element)services.item(idx);
            WsdlService service = new WsdlService();
            service.setUuid(UUID.randomUUID().toString());
            service.setArtifactType(BaseArtifactEnum.WSDL_SERVICE);
            service.setNamespace(this.targetNS);
            if (serviceElem.hasAttribute("name")) {
                String name = serviceElem.getAttribute("name");
                service.setName(name);
                service.setNCName(name);
            } else {
                service.setName("wsdl:service");
            }
            this.derivedArtifacts.add((BaseArtifactType)service);
            Collection<Port> ports = this.processPorts(serviceElem);
            for (Port port : ports) {
                PortTarget target = new PortTarget();
                target.setValue(port.getUuid());
                target.setArtifactType(PortEnum.PORT);
                service.getPort().add(target);
            }
        }
    }

    private Collection<Port> processPorts(Element serviceElem) throws XPathExpressionException {
        LinkedList<Port> rval = new LinkedList<Port>();
        NodeList ports = (NodeList)this.query(serviceElem, "./wsdl:port", XPathConstants.NODESET);
        for (int idx = 0; idx < ports.getLength(); ++idx) {
            Element portElem = (Element)ports.item(idx);
            Port port = new Port();
            port.setUuid(UUID.randomUUID().toString());
            port.setArtifactType(BaseArtifactEnum.PORT);
            port.setNamespace(this.targetNS);
            if (portElem.hasAttribute("name")) {
                String name = portElem.getAttribute("name");
                port.setNCName(name);
                port.setName(name);
            } else {
                port.setName("wsdl:port");
            }
            if (portElem.hasAttribute("binding")) {
                String bindingEncodedQName = portElem.getAttribute("binding");
                QName bindingQName = this.resolveQName(portElem, this.targetNS, bindingEncodedQName);
                Binding binding = this.derivedArtifacts.lookupBinding(bindingQName);
                BindingTarget target = new BindingTarget();
                target.setArtifactType(BindingEnum.BINDING);
                if (binding != null) {
                    target.setValue(binding.getUuid());
                } else {
                    this.relationshipSources.add(new QNameRelationshipSource(bindingQName, (Target)target, null, ArtifactTypeEnum.Binding.getModel(), ArtifactTypeEnum.Binding.getType()));
                }
                port.setBinding(target);
            }
            this.derivedArtifacts.add((BaseArtifactType)port);
            rval.add(port);
            NodeList soapAddresses = (NodeList)this.query(portElem, "./soap:address", XPathConstants.NODESET);
            for (int jdx = 0; jdx < soapAddresses.getLength(); ++jdx) {
                Element soapAddressElem = (Element)soapAddresses.item(jdx);
                SoapAddress soapAddress = new SoapAddress();
                soapAddress.setUuid(UUID.randomUUID().toString());
                soapAddress.setArtifactType(BaseArtifactEnum.SOAP_ADDRESS);
                soapAddress.setName("soap:address");
                soapAddress.setNCName(soapAddressElem.getLocalName());
                soapAddress.setNamespace(soapAddressElem.getNamespaceURI());
                soapAddress.setSoapLocation(soapAddressElem.getAttribute("location"));
                this.derivedArtifacts.add((BaseArtifactType)soapAddress);
                WsdlExtensionTarget target = new WsdlExtensionTarget();
                target.setArtifactType(WsdlExtensionEnum.WSDL_EXTENSION);
                target.setValue(soapAddress.getUuid());
                port.getExtension().add(target);
            }
        }
        return rval;
    }

    private void processWsdlImports() throws XPathExpressionException {
        if (!(this.getPrimaryArtifact() instanceof WsdlDocument)) {
            return;
        }
        WsdlDocument wsdlDocument = (WsdlDocument)this.getPrimaryArtifact();
        NodeList nodes = (NodeList)this.query(this.rootElement, ".//wsdl:import", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("namespace")) continue;
            String namespace = node.getAttribute("namespace");
            String location = node.getAttribute("location");
            this.stripPath(location);
            WsdlDocument wsdlDocumentRef = this.derivedArtifacts.lookupWsdlDocument(namespace);
            WsdlDocumentTarget wsdlDocumentTarget = new WsdlDocumentTarget();
            wsdlDocumentTarget.setArtifactType(WsdlDocumentEnum.WSDL_DOCUMENT);
            if (wsdlDocumentRef != null) {
                wsdlDocumentTarget.setValue(wsdlDocumentRef.getUuid());
            } else {
                this.relationshipSources.add(new NamespaceRelationshipSource(namespace, location, (Target)wsdlDocumentTarget, wsdlDocument.getImportedWsdls(), ArtifactTypeEnum.WsdlDocument.getModel(), ArtifactTypeEnum.WsdlDocument.getType()));
            }
            wsdlDocument.getImportedWsdls().add(wsdlDocumentTarget);
        }
    }

    private QName resolveQName(Element context, String defaultNamespace, String encodedQName) {
        int idx = encodedQName.indexOf(":");
        if (idx == -1) {
            return new QName(defaultNamespace, encodedQName);
        }
        String prefix = encodedQName.substring(0, idx);
        String localPart = encodedQName.substring(idx + 1);
        String namespace = this.resolveNamespaceByPrefix(context, prefix);
        if (namespace == null) {
            return new QName(null, encodedQName);
        }
        return new QName(namespace, localPart, prefix);
    }

    private String resolveNamespaceByPrefix(Element context, String prefix) {
        String nsDecl = "xmlns:" + prefix;
        Element elem = context;
        String ns = null;
        while (elem != null) {
            if (elem.hasAttribute(nsDecl)) {
                ns = elem.getAttribute(nsDecl);
                break;
            }
            if (elem.getParentNode().getNodeType() == 1) {
                elem = (Element)elem.getParentNode();
                continue;
            }
            elem = null;
        }
        return ns;
    }
}

