/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.integration;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.artificer.atom.archive.ArchiveUtils;
import org.artificer.common.ArtifactContent;
import org.artificer.common.ArtifactType;

public class ArchiveContext {
    private final ArtifactContent artifactContent;
    private final File archiveWorkDir;
    private ArtifactType archiveArtifactType = null;
    private Map<String, Object> customContext = new HashMap<String, Object>();

    public ArchiveContext(ArtifactContent artifactContent, File archiveWorkDir) {
        this.artifactContent = artifactContent;
        this.archiveWorkDir = archiveWorkDir;
    }

    public File getArchiveEntry(String entryPath) {
        File file = new File(this.archiveWorkDir, entryPath);
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    public boolean hasArchiveEntry(String entryPath) {
        return this.getArchiveEntry(entryPath) != null;
    }

    public boolean isArchive() {
        return this.archiveArtifactType == null;
    }

    public boolean isExpandedFromArchive() {
        return this.archiveArtifactType != null;
    }

    public boolean isExtendedTypeArchive(String archiveExtendedType) {
        if (this.archiveArtifactType != null) {
            return this.archiveArtifactType.isExtendedType() && this.archiveArtifactType.getExtendedType().equalsIgnoreCase(archiveExtendedType);
        }
        return false;
    }

    public ArtifactType getArchiveArtifactType() {
        return this.archiveArtifactType;
    }

    public void setArchiveArtifactType(ArtifactType archiveArtifactType) {
        this.archiveArtifactType = archiveArtifactType;
    }

    public Collection<File> expand() {
        return FileUtils.listFiles((File)this.archiveWorkDir, (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    public String stripWorkDir(String path) {
        return path.replace(this.archiveWorkDir.getAbsolutePath(), "");
    }

    public void addCustomContext(String key, Object value) {
        this.customContext.put(key, value);
    }

    public boolean hasCustomContext(String key) {
        return this.customContext.containsKey(key);
    }

    public Object getCustomContext(String key) {
        return this.customContext.get(key);
    }

    public void cleanup() {
        if (this.archiveWorkDir != null) {
            this.archiveWorkDir.delete();
        }
    }

    public static ArchiveContext createArchiveContext(ArtifactContent content) throws IOException {
        File archiveWorkDir = File.createTempFile(UUID.randomUUID().toString(), ".work");
        archiveWorkDir.delete();
        archiveWorkDir.mkdir();
        ArchiveUtils.unpackToWorkDir((File)content.getFile(), (File)archiveWorkDir);
        return new ArchiveContext(content, archiveWorkDir);
    }
}

