/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.integration.artifactbuilder;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.artificer.common.ArtifactTypeEnum;
import org.artificer.common.query.xpath.StaticNamespaceContext;
import org.artificer.integration.artifactbuilder.IndexedArtifactCollection;
import org.artificer.integration.artifactbuilder.NamespaceRelationshipSource;
import org.artificer.integration.artifactbuilder.XmlArtifactBuilder;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.AttributeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ComplexTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SimpleTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocumentEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocumentTarget;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XsdDocumentArtifactBuilder
extends XmlArtifactBuilder {
    protected IndexedArtifactCollection derivedArtifacts = new IndexedArtifactCollection();

    @Override
    protected void configureNamespaceMappings(StaticNamespaceContext namespaceContext) {
        super.configureNamespaceMappings(namespaceContext);
        namespaceContext.addMapping("xs", "http://www.w3.org/2001/XMLSchema");
        namespaceContext.addMapping("xsd", "http://www.w3.org/2001/XMLSchema");
    }

    @Override
    protected void derive() throws IOException {
        try {
            String targetNS = this.rootElement.getAttribute("targetNamespace");
            if (this.getPrimaryArtifact() instanceof XsdDocument) {
                ((XsdDocument)this.getPrimaryArtifact()).setTargetNamespace(targetNS);
            }
            this.deriveXsd(this.rootElement);
            this.processImportedXsds(this.rootElement, targetNS);
            this.processIncludedXsds(this.rootElement, targetNS);
            this.processRedefinedXsds(this.rootElement, targetNS);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void deriveXsd(Element schema) throws XPathExpressionException {
        String targetNS = schema.getAttribute("targetNamespace");
        this.processElementDeclarations(schema, targetNS);
        this.processAttributeDeclarations(schema, targetNS);
        this.processSimpleTypeDeclarations(schema, targetNS);
        this.processComplexTypeDeclarations(schema, targetNS);
    }

    private void processElementDeclarations(Element schema, String targetNS) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(schema, "./xsd:element", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("name")) continue;
            String nsName = node.getAttribute("name");
            ElementDeclaration elementDecl = new ElementDeclaration();
            elementDecl.setArtifactType(BaseArtifactEnum.ELEMENT_DECLARATION);
            elementDecl.setName(nsName);
            elementDecl.setNamespace(targetNS);
            elementDecl.setNCName(nsName);
            this.derivedArtifacts.add((BaseArtifactType)elementDecl);
        }
    }

    private void processAttributeDeclarations(Element schema, String targetNS) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(schema, "./xsd:attribute", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("name")) continue;
            String nsName = node.getAttribute("name");
            AttributeDeclaration attributeDecl = new AttributeDeclaration();
            attributeDecl.setArtifactType(BaseArtifactEnum.ATTRIBUTE_DECLARATION);
            attributeDecl.setName(nsName);
            attributeDecl.setNamespace(targetNS);
            attributeDecl.setNCName(nsName);
            this.derivedArtifacts.add((BaseArtifactType)attributeDecl);
        }
    }

    private void processSimpleTypeDeclarations(Element schema, String targetNS) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(schema, "./xsd:simpleType", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("name")) continue;
            String nsName = node.getAttribute("name");
            SimpleTypeDeclaration simpleTypeDecl = new SimpleTypeDeclaration();
            simpleTypeDecl.setArtifactType(BaseArtifactEnum.SIMPLE_TYPE_DECLARATION);
            simpleTypeDecl.setName(nsName);
            simpleTypeDecl.setNamespace(targetNS);
            simpleTypeDecl.setNCName(nsName);
            this.derivedArtifacts.add((BaseArtifactType)simpleTypeDecl);
        }
    }

    private void processComplexTypeDeclarations(Element schema, String targetNS) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(schema, "./xsd:complexType", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("name")) continue;
            String nsName = node.getAttribute("name");
            ComplexTypeDeclaration complexTypeDecl = new ComplexTypeDeclaration();
            complexTypeDecl.setArtifactType(BaseArtifactEnum.COMPLEX_TYPE_DECLARATION);
            complexTypeDecl.setName(nsName);
            complexTypeDecl.setNamespace(targetNS);
            complexTypeDecl.setNCName(nsName);
            this.derivedArtifacts.add((BaseArtifactType)complexTypeDecl);
        }
    }

    private void processImportedXsds(Element schema, String targetNS) throws XPathExpressionException {
        if (this.getPrimaryArtifact() instanceof XsdDocument) {
            this.processImportedXsds(((XsdDocument)this.getPrimaryArtifact()).getImportedXsds(), schema, targetNS);
        }
    }

    protected void processImportedXsds(List<XsdDocumentTarget> targetCollection, Element schema, String targetNS) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(schema, "./xsd:import", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("namespace") || !node.hasAttribute("schemaLocation")) continue;
            String namespace = node.getAttribute("namespace");
            String schemaLocation = node.getAttribute("schemaLocation");
            this.stripPath(schemaLocation);
            XsdDocument xsdDocumentRef = this.derivedArtifacts.lookupXsdDocument(namespace, schemaLocation);
            XsdDocumentTarget xsdDocumentTarget = new XsdDocumentTarget();
            xsdDocumentTarget.setArtifactType(XsdDocumentEnum.XSD_DOCUMENT);
            if (xsdDocumentRef != null) {
                xsdDocumentTarget.setValue(xsdDocumentRef.getUuid());
            } else {
                this.relationshipSources.add(new NamespaceRelationshipSource(namespace, schemaLocation, (Target)xsdDocumentTarget, targetCollection, ArtifactTypeEnum.XsdDocument.getModel(), ArtifactTypeEnum.XsdDocument.getType()));
            }
            targetCollection.add(xsdDocumentTarget);
        }
    }

    private void processIncludedXsds(Element schema, String targetNS) throws XPathExpressionException {
        if (this.getPrimaryArtifact() instanceof XsdDocument) {
            this.processIncludedXsds(((XsdDocument)this.getPrimaryArtifact()).getIncludedXsds(), schema, targetNS);
        }
    }

    protected void processIncludedXsds(List<XsdDocumentTarget> targetCollection, Element schema, String targetNS) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(schema, "./xsd:include", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("schemaLocation")) continue;
            String schemaLocation = node.getAttribute("schemaLocation");
            this.stripPath(schemaLocation);
            XsdDocument xsdDocumentRef = this.derivedArtifacts.lookupXsdDocument(targetNS, schemaLocation);
            XsdDocumentTarget xsdDocumentTarget = new XsdDocumentTarget();
            xsdDocumentTarget.setArtifactType(XsdDocumentEnum.XSD_DOCUMENT);
            if (xsdDocumentRef != null) {
                xsdDocumentTarget.setValue(xsdDocumentRef.getUuid());
            } else {
                this.relationshipSources.add(new NamespaceRelationshipSource(targetNS, schemaLocation, (Target)xsdDocumentTarget, targetCollection, ArtifactTypeEnum.XsdDocument.getModel(), ArtifactTypeEnum.XsdDocument.getType()));
            }
            targetCollection.add(xsdDocumentTarget);
        }
    }

    private void processRedefinedXsds(Element schema, String targetNS) throws XPathExpressionException {
        if (this.getPrimaryArtifact() instanceof XsdDocument) {
            this.processRedefinedXsds(((XsdDocument)this.getPrimaryArtifact()).getRedefinedXsds(), schema, targetNS);
        }
    }

    protected void processRedefinedXsds(List<XsdDocumentTarget> targetCollection, Element schema, String targetNS) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(schema, "./xsd:redefine", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("schemaLocation")) continue;
            String schemaLocation = node.getAttribute("schemaLocation");
            this.stripPath(schemaLocation);
            XsdDocument xsdDocumentRef = this.derivedArtifacts.lookupXsdDocument(targetNS, schemaLocation);
            XsdDocumentTarget xsdDocumentTarget = new XsdDocumentTarget();
            xsdDocumentTarget.setArtifactType(XsdDocumentEnum.XSD_DOCUMENT);
            if (xsdDocumentRef != null) {
                xsdDocumentTarget.setValue(xsdDocumentRef.getUuid());
            } else {
                this.relationshipSources.add(new NamespaceRelationshipSource(targetNS, schemaLocation, (Target)xsdDocumentTarget, targetCollection, ArtifactTypeEnum.XsdDocument.getModel(), ArtifactTypeEnum.XsdDocument.getType()));
            }
            targetCollection.add(xsdDocumentTarget);
        }
    }

    protected void stripPath(String s) {
        if (s.lastIndexOf("/") > -1) {
            s = s.substring(s.lastIndexOf("/"));
        }
        if (s.lastIndexOf("\\") > -1) {
            s = s.substring(s.lastIndexOf("\\"));
        }
    }

    @Override
    public Collection<BaseArtifactType> getDerivedArtifacts() {
        return this.derivedArtifacts;
    }
}

