/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate;

import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.artificer.common.ArtificerException;
import org.artificer.common.error.ArtificerServerException;
import org.artificer.common.error.ArtificerUserException;
import org.artificer.repository.AuditManager;
import org.artificer.repository.hibernate.HibernateUtil;
import org.artificer.repository.hibernate.audit.ArtificerAuditEntry;
import org.artificer.repository.hibernate.audit.HibernateAuditor;
import org.artificer.repository.hibernate.entity.ArtificerArtifact;
import org.artificer.repository.query.ArtificerQueryArgs;
import org.artificer.repository.query.PagedResult;
import org.jboss.downloads.artificer._2013.auditing.AuditEntry;

public class HibernateAuditManager
implements AuditManager {
    public void login(String username, String password) {
    }

    public AuditEntry addAuditEntry(final String artifactUuid, final AuditEntry srampAuditEntry) throws ArtificerException {
        return (AuditEntry)new HibernateUtil.HibernateTask<AuditEntry>(){

            @Override
            protected AuditEntry doExecute(EntityManager entityManager) throws Exception {
                if (StringUtils.isBlank((String)srampAuditEntry.getUuid())) {
                    srampAuditEntry.setUuid(UUID.randomUUID().toString());
                }
                ArtificerArtifact artifact = HibernateUtil.getArtifact(artifactUuid, entityManager, false);
                entityManager.persist((Object)HibernateAuditor.auditEntry(srampAuditEntry, artifact));
                return srampAuditEntry;
            }
        }.execute();
    }

    public AuditEntry getArtifactAuditEntry(final String artifactUuid, final String auditEntryUuid) throws ArtificerException {
        return (AuditEntry)new HibernateUtil.HibernateTask<AuditEntry>(){

            @Override
            protected AuditEntry doExecute(EntityManager entityManager) throws Exception {
                Query q = entityManager.createQuery("SELECT au FROM ArtificerAuditEntry au WHERE au.uuid=:uuid ORDER BY au.id DESC");
                q.setParameter("uuid", (Object)auditEntryUuid);
                ((org.hibernate.Query)q.unwrap(org.hibernate.Query.class)).setCacheable(true);
                try {
                    ArtificerAuditEntry auditEntry = (ArtificerAuditEntry)q.getSingleResult();
                    return HibernateAuditor.auditEntry(auditEntry);
                }
                catch (NoResultException e) {
                    throw ArtificerUserException.auditEntryNotFound((String)artifactUuid, (String)auditEntryUuid);
                }
            }
        }.execute();
    }

    public PagedResult<AuditEntry> getArtifactAuditEntries(final String artifactUuid, final ArtificerQueryArgs args) throws ArtificerException {
        try {
            return (PagedResult)new HibernateUtil.HibernateTask<PagedResult<AuditEntry>>(){

                @Override
                protected PagedResult<AuditEntry> doExecute(EntityManager entityManager) throws Exception {
                    Query q = entityManager.createQuery("SELECT au FROM ArtificerAuditEntry au INNER JOIN au.artifact a WHERE a.uuid=:uuid ORDER BY au.id DESC");
                    q.setParameter("uuid", (Object)artifactUuid);
                    ((org.hibernate.Query)q.unwrap(org.hibernate.Query.class)).setCacheable(true);
                    args.applyPaging(q);
                    List auditEntries = q.getResultList();
                    q = entityManager.createQuery("SELECT count(au) FROM ArtificerAuditEntry au INNER JOIN au.artifact a WHERE a.uuid=:uuid");
                    q.setParameter("uuid", (Object)artifactUuid);
                    ((org.hibernate.Query)q.unwrap(org.hibernate.Query.class)).setCacheable(true);
                    args.applyPaging(q);
                    long totalSize = (Long)q.getSingleResult();
                    return new PagedResult(HibernateAuditor.auditEntries(auditEntries), "", totalSize, args);
                }
            }.execute();
        }
        catch (ArtificerException ae) {
            throw ae;
        }
        catch (Throwable t) {
            throw new ArtificerServerException(t);
        }
    }

    public PagedResult<AuditEntry> getArtifactAuditEntries(String artifactUuid) throws ArtificerException {
        return this.getArtifactAuditEntries(artifactUuid, new ArtificerQueryArgs());
    }

    public PagedResult<AuditEntry> getUserAuditEntries(final String username, final ArtificerQueryArgs args) throws ArtificerException {
        try {
            return (PagedResult)new HibernateUtil.HibernateTask<PagedResult<AuditEntry>>(){

                @Override
                protected PagedResult<AuditEntry> doExecute(EntityManager entityManager) throws Exception {
                    Query q = entityManager.createQuery("SELECT au FROM ArtificerAuditEntry au WHERE au.modifiedBy.username=:username ORDER BY au.id DESC");
                    q.setParameter("username", (Object)username);
                    ((org.hibernate.Query)q.unwrap(org.hibernate.Query.class)).setCacheable(true);
                    args.applyPaging(q);
                    List auditEntries = q.getResultList();
                    q = entityManager.createQuery("SELECT count(au) FROM ArtificerAuditEntry au WHERE au.modifiedBy.username=:username");
                    q.setParameter("username", (Object)username);
                    ((org.hibernate.Query)q.unwrap(org.hibernate.Query.class)).setCacheable(true);
                    args.applyPaging(q);
                    long totalSize = (Long)q.getSingleResult();
                    return new PagedResult(HibernateAuditor.auditEntries(auditEntries), "", totalSize, args);
                }
            }.execute();
        }
        catch (ArtificerException ae) {
            throw ae;
        }
        catch (Throwable t) {
            throw new ArtificerServerException(t);
        }
    }

    public PagedResult<AuditEntry> getUserAuditEntries(String username) throws ArtificerException {
        return this.getUserAuditEntries(username, new ArtificerQueryArgs());
    }
}

