/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.artificer.repository.filter.ServletCredentialsFilter;
import org.artificer.repository.hibernate.entity.ArtificerStoredQuery;
import org.artificer.repository.hibernate.entity.ArtificerUser;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;

public class HibernateEntityFactory {
    private static final DatatypeFactory DATATYPE_FACTORY;

    public static List<StoredQuery> storedQueries(List<ArtificerStoredQuery> artificerStoredQueries) {
        ArrayList<StoredQuery> srampStoredQueries = new ArrayList<StoredQuery>();
        for (ArtificerStoredQuery artificerStoredQuery : artificerStoredQueries) {
            srampStoredQueries.add(HibernateEntityFactory.storedQuery(artificerStoredQuery));
        }
        return srampStoredQueries;
    }

    public static ArtificerStoredQuery storedQuery(StoredQuery srampStoredQuery) {
        ArtificerStoredQuery artificerStoredQuery = new ArtificerStoredQuery();
        HibernateEntityFactory.processStoredQuery(artificerStoredQuery, srampStoredQuery);
        return artificerStoredQuery;
    }

    public static void processStoredQuery(ArtificerStoredQuery artificerStoredQuery, StoredQuery srampStoredQuery) {
        artificerStoredQuery.setQueryExpression(srampStoredQuery.getQueryExpression());
        artificerStoredQuery.setQueryName(srampStoredQuery.getQueryName());
        artificerStoredQuery.getPropertyNames().clear();
        for (String propertyName : srampStoredQuery.getPropertyName()) {
            artificerStoredQuery.getPropertyNames().add(propertyName);
        }
    }

    public static StoredQuery storedQuery(ArtificerStoredQuery artificerStoredQuery) {
        StoredQuery srampStoredQuery = new StoredQuery();
        srampStoredQuery.setQueryExpression(artificerStoredQuery.getQueryExpression());
        srampStoredQuery.setQueryName(artificerStoredQuery.getQueryName());
        for (String propertyName : artificerStoredQuery.getPropertyNames()) {
            srampStoredQuery.getPropertyName().add(propertyName);
        }
        return srampStoredQuery;
    }

    public static ArtificerUser user() {
        ArtificerUser artificerUser = new ArtificerUser();
        artificerUser.setLastActionTime(Calendar.getInstance());
        artificerUser.setUsername(ServletCredentialsFilter.getUsername());
        return artificerUser;
    }

    public static ArtificerUser user(String username, XMLGregorianCalendar time) {
        if (StringUtils.isBlank((String)username)) {
            return HibernateEntityFactory.user();
        }
        ArtificerUser artificerUser = new ArtificerUser();
        if (time != null) {
            artificerUser.setLastActionTime(time.toGregorianCalendar());
        } else {
            artificerUser.setLastActionTime(Calendar.getInstance());
        }
        if (StringUtils.isNotBlank((String)username)) {
            artificerUser.setUsername(username);
        } else {
            artificerUser.setUsername(ServletCredentialsFilter.getUsername());
        }
        return artificerUser;
    }

    public static XMLGregorianCalendar calendar(Calendar c) {
        return HibernateEntityFactory.calendar(c.getTimeInMillis());
    }

    public static XMLGregorianCalendar calendar(long time) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(time);
        return DATATYPE_FACTORY.newXMLGregorianCalendar(gc);
    }

    static {
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

