/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate.audit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.artificer.repository.audit.ArtifactDiff;
import org.artificer.repository.hibernate.HibernateEntityFactory;
import org.artificer.repository.hibernate.audit.ArtificerAuditEntry;
import org.artificer.repository.hibernate.audit.ArtificerAuditItem;
import org.artificer.repository.hibernate.entity.ArtificerArtifact;
import org.jboss.downloads.artificer._2013.auditing.AuditEntry;
import org.jboss.downloads.artificer._2013.auditing.AuditItemType;

public class HibernateAuditor {
    private final Map<String, String> oldProperties;
    private final List<String> oldClassifiers;

    public HibernateAuditor(ArtificerArtifact oldArtifact) {
        this.oldProperties = oldArtifact.snapshotProperties();
        this.oldClassifiers = oldArtifact.getClassifiers();
    }

    public ArtificerAuditEntry diff(ArtificerArtifact newArtifact) {
        ArtifactDiff diff = new ArtifactDiff();
        Map<String, String> newProperties = newArtifact.snapshotProperties();
        List<String> newClassifiers = newArtifact.getClassifiers();
        for (String string : newProperties.keySet()) {
            String newValue = newProperties.get(string);
            String string2 = newValue = newValue == null ? "" : newValue;
            if (this.oldProperties.containsKey(string)) {
                String oldValue = this.oldProperties.get(string);
                String string3 = oldValue = oldValue == null ? "" : oldValue;
                if (!oldValue.equals(newValue)) {
                    diff.getUpdatedProperties().put(string, newValue);
                }
                this.oldProperties.remove(string);
                continue;
            }
            diff.getAddedProperties().put(string, newValue);
        }
        for (String string : newClassifiers) {
            if (!this.oldClassifiers.contains(string)) {
                diff.getAddedClassifiers().add(string);
            }
            this.oldClassifiers.remove(string);
        }
        for (Map.Entry entry : this.oldProperties.entrySet()) {
            String name = (String)entry.getKey();
            diff.getDeletedProperties().add(name);
        }
        for (String string : this.oldClassifiers) {
            diff.getDeletedClassifiers().add(string);
        }
        ArtificerAuditEntry artificerAuditEntry = new ArtificerAuditEntry();
        artificerAuditEntry.setUuid(UUID.randomUUID().toString());
        artificerAuditEntry.setModifiedBy(HibernateEntityFactory.user());
        artificerAuditEntry.setType("artifact:update");
        HibernateAuditor.createAuditItem(artificerAuditEntry, "property:added", diff.getAddedProperties());
        HibernateAuditor.createAuditItem(artificerAuditEntry, "property:changed", diff.getUpdatedProperties());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String deletedProperty : diff.getDeletedProperties()) {
            hashMap.put(deletedProperty, "");
        }
        HibernateAuditor.createAuditItem(artificerAuditEntry, "property:removed", hashMap);
        HashMap<String, String> addedClassifiers = new HashMap<String, String>();
        int idx = 0;
        for (String addedClassifier : diff.getAddedClassifiers()) {
            addedClassifiers.put("classifier-" + idx++, addedClassifier);
        }
        HibernateAuditor.createAuditItem(artificerAuditEntry, "classifier:added", addedClassifiers);
        HashMap<String, String> deletedClassifiers = new HashMap<String, String>();
        idx = 0;
        for (String deletedClassifier : diff.getDeletedClassifiers()) {
            deletedClassifiers.put("classifier-" + idx++, deletedClassifier);
        }
        HibernateAuditor.createAuditItem(artificerAuditEntry, "classifier:removed", deletedClassifiers);
        artificerAuditEntry.setArtifact(newArtifact);
        newArtifact.getAuditEntries().add(artificerAuditEntry);
        return artificerAuditEntry;
    }

    public static ArtificerAuditEntry createAddEntry(ArtificerArtifact artifact) {
        ArtificerAuditEntry artificerAuditEntry = new ArtificerAuditEntry();
        artificerAuditEntry.setUuid(UUID.randomUUID().toString());
        artificerAuditEntry.setModifiedBy(HibernateEntityFactory.user());
        artificerAuditEntry.setType("artifact:add");
        HibernateAuditor.createAuditItem(artificerAuditEntry, "property:added", artifact.snapshotProperties());
        HashMap<String, String> addedClassifiers = new HashMap<String, String>();
        int idx = 0;
        for (String addedClassifier : artifact.getClassifiers()) {
            addedClassifiers.put("classifier-" + idx++, addedClassifier);
        }
        HibernateAuditor.createAuditItem(artificerAuditEntry, "classifier:added", addedClassifiers);
        artificerAuditEntry.setArtifact(artifact);
        artifact.getAuditEntries().add(artificerAuditEntry);
        return artificerAuditEntry;
    }

    public static ArtificerAuditEntry createDeleteEntry(ArtificerArtifact artifact) {
        ArtificerAuditEntry artificerAuditEntry = new ArtificerAuditEntry();
        artificerAuditEntry.setUuid(UUID.randomUUID().toString());
        artificerAuditEntry.setModifiedBy(HibernateEntityFactory.user());
        artificerAuditEntry.setType("artifact:delete");
        artificerAuditEntry.setArtifact(artifact);
        artifact.getAuditEntries().add(artificerAuditEntry);
        return artificerAuditEntry;
    }

    private static void createAuditItem(ArtificerAuditEntry artificerAuditEntry, String type, Map<String, String> properties) {
        if (!properties.isEmpty()) {
            ArtificerAuditItem artificerAuditItem = new ArtificerAuditItem();
            artificerAuditItem.setType(type);
            artificerAuditItem.getProperties().putAll(properties);
            artificerAuditItem.setAuditEntry(artificerAuditEntry);
            artificerAuditEntry.getItems().add(artificerAuditItem);
        }
    }

    public static List<AuditEntry> auditEntries(List<ArtificerAuditEntry> artificerAuditEntries) {
        ArrayList<AuditEntry> auditEntries = new ArrayList<AuditEntry>();
        for (ArtificerAuditEntry artificerAuditEntry : artificerAuditEntries) {
            auditEntries.add(HibernateAuditor.auditEntry(artificerAuditEntry));
        }
        return auditEntries;
    }

    public static AuditEntry auditEntry(ArtificerAuditEntry artificerAuditEntry) {
        AuditEntry auditEntry = new AuditEntry();
        auditEntry.setWhen(HibernateEntityFactory.calendar(artificerAuditEntry.getModifiedBy().getLastActionTime()));
        auditEntry.setWho(artificerAuditEntry.getModifiedBy().getUsername());
        auditEntry.setUuid(artificerAuditEntry.getUuid());
        auditEntry.setType(artificerAuditEntry.getType());
        for (ArtificerAuditItem artificerAuditItem : artificerAuditEntry.getItems()) {
            AuditItemType auditItem = new AuditItemType();
            auditItem.setType(artificerAuditItem.getType());
            for (String key : artificerAuditItem.getProperties().keySet()) {
                String value = artificerAuditItem.getProperties().get(key);
                AuditItemType.Property property = new AuditItemType.Property();
                property.setName(key);
                property.setValue(value);
                auditItem.getProperty().add(property);
            }
            auditEntry.getAuditItem().add(auditItem);
        }
        return auditEntry;
    }

    public static ArtificerAuditEntry auditEntry(AuditEntry srampAuditEntry, ArtificerArtifact artifact) {
        ArtificerAuditEntry auditEntry = new ArtificerAuditEntry();
        auditEntry.setModifiedBy(HibernateEntityFactory.user());
        auditEntry.setUuid(srampAuditEntry.getUuid());
        auditEntry.setType(srampAuditEntry.getType());
        for (AuditItemType srampAuditItem : srampAuditEntry.getAuditItem()) {
            ArtificerAuditItem auditItem = new ArtificerAuditItem();
            auditItem.setType(srampAuditItem.getType());
            for (AuditItemType.Property srampProperty : srampAuditItem.getProperty()) {
                auditItem.getProperties().put(srampProperty.getName(), srampProperty.getValue());
            }
            auditEntry.getItems().add(auditItem);
            auditItem.setAuditEntry(auditEntry);
        }
        auditEntry.setArtifact(artifact);
        artifact.getAuditEntries().add(auditEntry);
        return auditEntry;
    }
}

