/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate.data;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerConstants;
import org.artificer.common.query.RelationshipType;
import org.artificer.common.visitors.ArtifactVisitor;
import org.artificer.common.visitors.ArtifactVisitorHelper;
import org.artificer.common.visitors.HierarchicalArtifactVisitor;
import org.artificer.repository.hibernate.HibernateEntityFactory;
import org.artificer.repository.hibernate.entity.ArtificerArtifact;
import org.artificer.repository.hibernate.entity.ArtificerComment;
import org.artificer.repository.hibernate.entity.ArtificerDocumentArtifact;
import org.artificer.repository.hibernate.entity.ArtificerProperty;
import org.artificer.repository.hibernate.entity.ArtificerRelationship;
import org.artificer.repository.hibernate.entity.ArtificerTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Actor;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ActorTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.AttributeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Binding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationFaultTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationInputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationOutputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Comment;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ComplexTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.EffectTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Element;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclarationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.EventTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Fault;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.FaultTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.InformationTypeTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Message;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.MessageTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.NamedWsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Operation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutputTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationProcessTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OrchestrationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Organization;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Part;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PartTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Policy;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicySubjectTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicyTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Port;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortTypeTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Service;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContract;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContractTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceEndpoint;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstance;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstanceTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInterface;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInterfaceTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperationTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SimpleTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoaModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapAddress;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoapBinding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.TaskTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocumentTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlExtensionTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlService;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocumentTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdTypeTarget;

public class HibernateEntityToSrampVisitor
extends HierarchicalArtifactVisitor {
    private final ArtificerArtifact artificerArtifact;
    private final ArtifactType artifactType;
    private final boolean includeAssociations;

    public static BaseArtifactType visit(ArtificerArtifact artificerArtifact, boolean includeAssociations) throws Exception {
        return HibernateEntityToSrampVisitor.visit(artificerArtifact, ArtifactType.valueOf((String)artificerArtifact.getType(), (boolean)artificerArtifact.isDocument()), includeAssociations);
    }

    public static BaseArtifactType visit(ArtificerArtifact artificerArtifact, ArtifactType artifactType, boolean includeAssociations) throws Exception {
        if (artifactType.isExtendedType() && artificerArtifact.isDocument()) {
            artifactType = ArtifactType.ExtendedDocument((String)artifactType.getExtendedType());
        }
        BaseArtifactType srampArtifact = artifactType.newArtifactInstance();
        HibernateEntityToSrampVisitor visitor = new HibernateEntityToSrampVisitor(artificerArtifact, artifactType, includeAssociations);
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)srampArtifact);
        visitor.throwError();
        return srampArtifact;
    }

    public HibernateEntityToSrampVisitor(ArtificerArtifact artificerArtifact, ArtifactType artifactType, boolean includeAssociations) {
        this.artificerArtifact = artificerArtifact;
        this.artifactType = artifactType;
        this.includeAssociations = includeAssociations;
    }

    protected void visitBase(BaseArtifactType srampArtifact) {
        super.visitBase(srampArtifact);
        try {
            srampArtifact.setDescription(this.artificerArtifact.getDescription());
            srampArtifact.setArtifactType(this.artifactType.getArtifactType().getApiType());
            srampArtifact.setCreatedBy(this.artificerArtifact.getCreatedBy().getUsername());
            XMLGregorianCalendar createdTimestamp = HibernateEntityFactory.calendar(this.artificerArtifact.getCreatedBy().getLastActionTime());
            srampArtifact.setCreatedTimestamp(createdTimestamp);
            srampArtifact.setLastModifiedBy(this.artificerArtifact.getModifiedBy().getUsername());
            XMLGregorianCalendar modifiedTimestamp = HibernateEntityFactory.calendar(this.artificerArtifact.getModifiedBy().getLastActionTime());
            srampArtifact.setLastModifiedTimestamp(modifiedTimestamp);
            srampArtifact.setName(this.artificerArtifact.getName());
            srampArtifact.setUuid(this.artificerArtifact.getUuid());
            srampArtifact.setVersion(this.artificerArtifact.getVersion());
            for (ArtificerProperty artificerProperty : this.artificerArtifact.getProperties()) {
                if (!artificerProperty.isCustom()) continue;
                Property srampProp = new Property();
                srampProp.setPropertyName(artificerProperty.getKey());
                srampProp.setPropertyValue(artificerProperty.getValue());
                srampArtifact.getProperty().add(srampProp);
            }
            if (this.includeAssociations) {
                if (this.artificerArtifact.isExpandedFromArchive()) {
                    srampArtifact.getOtherAttributes().put(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_UUID_QNAME, this.artificerArtifact.getExpandedFrom().getUuid());
                    srampArtifact.getOtherAttributes().put(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_PATH_QNAME, this.artificerArtifact.getExpandedFromArchivePath());
                }
                for (String uri : this.artificerArtifact.getClassifiers()) {
                    srampArtifact.getClassifiedBy().add(uri);
                }
                this.visitGenericRelationships(srampArtifact);
                this.visitComments(srampArtifact);
            }
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    private void visitGenericRelationships(BaseArtifactType srampArtifact) throws Exception {
        for (ArtificerRelationship artificerRelationship : this.artificerArtifact.getRelationships()) {
            if (artificerRelationship.getType() != RelationshipType.GENERIC) continue;
            Relationship srampRelationship = new Relationship();
            srampRelationship.setRelationshipType(artificerRelationship.getName());
            for (ArtificerTarget artificerTarget : artificerRelationship.getTargets()) {
                Target srampTarget = this.createTarget(Target.class, artificerTarget);
                srampRelationship.getRelationshipTarget().add(srampTarget);
            }
            this.setOtherAttributes(artificerRelationship.getOtherAttributes(), srampRelationship.getOtherAttributes());
            srampArtifact.getRelationship().add(srampRelationship);
        }
    }

    private void setOtherAttributes(Map<String, String> artificerAttributes, Map<QName, String> srampAttributes) throws Exception {
        for (String key : artificerAttributes.keySet()) {
            srampAttributes.put(QName.valueOf(key), artificerAttributes.get(key));
        }
    }

    private void visitComments(BaseArtifactType srampArtifact) throws Exception {
        for (ArtificerComment artificerComment : this.artificerArtifact.getComments()) {
            Comment srampComment = new Comment();
            srampComment.setCreatedBy(artificerComment.getCreatedBy().getUsername());
            XMLGregorianCalendar createdTimestamp = HibernateEntityFactory.calendar(artificerComment.getCreatedBy().getLastActionTime());
            srampComment.setCreatedTimestamp(createdTimestamp);
            srampComment.setText(artificerComment.getText());
            srampArtifact.getComment().add(srampComment);
        }
    }

    protected void visitDerived(DerivedArtifactType srampArtifact) {
        super.visitDerived(srampArtifact);
        try {
            ArtificerArtifact derivedFrom;
            if (this.includeAssociations && (derivedFrom = this.artificerArtifact.getDerivedFrom()) != null) {
                DocumentArtifactTarget target = new DocumentArtifactTarget();
                ArtifactType derivedFromType = ArtifactType.valueOf((String)derivedFrom.getType(), (boolean)derivedFrom.isDocument());
                DocumentArtifactEnum documentArtifactEnum = DocumentArtifactEnum.fromValue((BaseArtifactEnum)derivedFromType.getArtifactType().getApiType());
                target.setArtifactType(documentArtifactEnum);
                target.setValue(derivedFrom.getUuid());
                srampArtifact.setRelatedDocument(target);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void visitWsdlDerived(WsdlDerivedArtifactType artifact) {
        super.visitWsdlDerived(artifact);
        artifact.setNamespace(this.getProperty("namespace"));
        try {
            artifact.getExtension().addAll(this.getRelationships("extension", this.artificerArtifact, WsdlExtensionTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void visitNamedWsdlDerived(NamedWsdlDerivedArtifactType artifact) {
        super.visitNamedWsdlDerived(artifact);
        artifact.setNCName(this.getProperty("ncName"));
    }

    protected void visitDocument(DocumentArtifactType artifact) {
        super.visitDocument(artifact);
        ArtificerDocumentArtifact artificerDocumentArtifact = (ArtificerDocumentArtifact)this.artificerArtifact;
        artifact.setContentSize(Long.valueOf(artificerDocumentArtifact.getContentSize()));
        artifact.setContentType(artificerDocumentArtifact.getMimeType());
        artifact.setContentHash(artificerDocumentArtifact.getContentHash());
    }

    protected void visitXmlDocument(XmlDocument artifact) {
        super.visitXmlDocument(artifact);
        artifact.setContentEncoding(this.artificerArtifact.getContentEncoding());
    }

    protected void visitExtended(ExtendedArtifactType artifact) {
        super.visitExtended(artifact);
        String extendedType = this.artificerArtifact.getType();
        boolean extendedDerived = this.artificerArtifact.isDerived();
        artifact.setExtendedType(extendedType);
        artifact.getOtherAttributes().put(ArtificerConstants.SRAMP_DERIVED_QNAME, extendedDerived + "");
    }

    protected void visitExtendedDocument(ExtendedDocument artifact) {
        super.visitExtendedDocument(artifact);
        ArtificerDocumentArtifact artificerDocumentArtifact = (ArtificerDocumentArtifact)this.artificerArtifact;
        String extendedType = artificerDocumentArtifact.getType();
        String contentType = artificerDocumentArtifact.getMimeType();
        long contentLength = artificerDocumentArtifact.getContentSize();
        artifact.setExtendedType(extendedType);
        if (contentType != null) {
            artifact.getOtherAttributes().put(ArtificerConstants.SRAMP_CONTENT_SIZE_QNAME, contentLength + "");
            artifact.getOtherAttributes().put(ArtificerConstants.SRAMP_CONTENT_TYPE_QNAME, contentType);
        }
    }

    protected void visitServiceImplementation(ServiceImplementationModelType artifact) {
        super.visitServiceImplementation(artifact);
        try {
            artifact.getDocumentation().addAll(this.getRelationships("documentation", this.artificerArtifact, DocumentArtifactTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void visitSoa(SoaModelType artifact) {
        super.visitSoa(artifact);
        try {
            artifact.getDocumentation().addAll(this.getRelationships("documentation", this.artificerArtifact, DocumentArtifactTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void visitElement(Element artifact) {
        super.visitElement(artifact);
        try {
            artifact.getRepresents().addAll(this.getRelationships("represents", this.artificerArtifact, ElementTarget.class));
            artifact.getUses().addAll(this.getRelationships("uses", this.artificerArtifact, ElementTarget.class));
            artifact.getPerforms().addAll(this.getRelationships("performs", this.artificerArtifact, ServiceTarget.class));
            artifact.setDirectsOrchestration(this.getRelationship("directsOrchestration", this.artificerArtifact, OrchestrationTarget.class));
            artifact.setDirectsOrchestrationProcess(this.getRelationship("directsOrchestrationProcess", this.artificerArtifact, OrchestrationProcessTarget.class));
            artifact.getGenerates().addAll(this.getRelationships("generates", this.artificerArtifact, EventTarget.class));
            artifact.getRespondsTo().addAll(this.getRelationships("respondsTo", this.artificerArtifact, EventTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void visitActor(Actor artifact) {
        super.visitActor(artifact);
        try {
            artifact.getDoes().addAll(this.getRelationships("does", this.artificerArtifact, TaskTarget.class));
            artifact.getSetsPolicy().addAll(this.getRelationships("setsPolicy", this.artificerArtifact, PolicyTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(XsdDocument artifact) {
        super.visit(artifact);
        artifact.setTargetNamespace(this.getProperty("targetNamespace"));
        try {
            artifact.getImportedXsds().addAll(this.getRelationships("importedXsds", this.artificerArtifact, XsdDocumentTarget.class));
            artifact.getIncludedXsds().addAll(this.getRelationships("includedXsds", this.artificerArtifact, XsdDocumentTarget.class));
            artifact.getRedefinedXsds().addAll(this.getRelationships("redefinedXsds", this.artificerArtifact, XsdDocumentTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(AttributeDeclaration artifact) {
        super.visit(artifact);
        artifact.setNamespace(this.getProperty("namespace"));
    }

    public void visit(ComplexTypeDeclaration artifact) {
        super.visit(artifact);
        artifact.setNamespace(this.getProperty("namespace"));
    }

    public void visit(ElementDeclaration artifact) {
        super.visit(artifact);
        artifact.setNamespace(this.getProperty("namespace"));
    }

    public void visit(SimpleTypeDeclaration artifact) {
        super.visit(artifact);
        artifact.setNamespace(this.getProperty("namespace"));
    }

    public void visit(WsdlDocument artifact) {
        super.visit(artifact);
        artifact.setTargetNamespace(this.getProperty("targetNamespace"));
        try {
            artifact.getImportedXsds().addAll(this.getRelationships("importedXsds", this.artificerArtifact, XsdDocumentTarget.class));
            artifact.getIncludedXsds().addAll(this.getRelationships("includedXsds", this.artificerArtifact, XsdDocumentTarget.class));
            artifact.getRedefinedXsds().addAll(this.getRelationships("redefinedXsds", this.artificerArtifact, XsdDocumentTarget.class));
            artifact.getImportedWsdls().addAll(this.getRelationships("importedWsdls", this.artificerArtifact, WsdlDocumentTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Message artifact) {
        super.visit(artifact);
        try {
            artifact.getPart().addAll(this.getRelationships("part", this.artificerArtifact, PartTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Part artifact) {
        super.visit(artifact);
        try {
            artifact.setElement(this.getRelationship("element", this.artificerArtifact, ElementDeclarationTarget.class));
            artifact.setType(this.getRelationship("type", this.artificerArtifact, XsdTypeTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(PortType artifact) {
        super.visit(artifact);
        try {
            artifact.getOperation().addAll(this.getRelationships("operation", this.artificerArtifact, OperationTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Operation artifact) {
        super.visit(artifact);
        try {
            artifact.setInput(this.getRelationship("input", this.artificerArtifact, OperationInputTarget.class));
            artifact.setOutput(this.getRelationship("output", this.artificerArtifact, OperationOutputTarget.class));
            artifact.getFault().addAll(this.getRelationships("fault", this.artificerArtifact, FaultTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(OperationInput artifact) {
        super.visit(artifact);
        try {
            artifact.setMessage(this.getRelationship("message", this.artificerArtifact, MessageTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(OperationOutput artifact) {
        super.visit(artifact);
        try {
            artifact.setMessage(this.getRelationship("message", this.artificerArtifact, MessageTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Fault artifact) {
        super.visit(artifact);
        try {
            artifact.setMessage(this.getRelationship("message", this.artificerArtifact, MessageTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Binding artifact) {
        super.visit(artifact);
        try {
            artifact.getBindingOperation().addAll(this.getRelationships("bindingOperation", this.artificerArtifact, BindingOperationTarget.class));
            artifact.setPortType(this.getRelationship("portType", this.artificerArtifact, PortTypeTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(SoapBinding artifact) {
        super.visit(artifact);
        artifact.setStyle(this.getProperty("style"));
        artifact.setTransport(this.getProperty("transport"));
    }

    public void visit(BindingOperation artifact) {
        super.visit(artifact);
        try {
            artifact.setInput(this.getRelationship("input", this.artificerArtifact, BindingOperationInputTarget.class));
            artifact.setOutput(this.getRelationship("output", this.artificerArtifact, BindingOperationOutputTarget.class));
            artifact.getFault().addAll(this.getRelationships("fault", this.artificerArtifact, BindingOperationFaultTarget.class));
            artifact.setOperation(this.getRelationship("operation", this.artificerArtifact, OperationTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(WsdlService artifact) {
        super.visit(artifact);
        try {
            artifact.getPort().addAll(this.getRelationships("port", this.artificerArtifact, PortTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Port artifact) {
        super.visit(artifact);
        try {
            artifact.setBinding(this.getRelationship("binding", this.artificerArtifact, BindingTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(SoapAddress artifact) {
        super.visit(artifact);
        artifact.setSoapLocation(this.getProperty("soapLocation"));
    }

    public void visit(ServiceEndpoint artifact) {
        super.visit(artifact);
        try {
            artifact.setEndpointDefinedBy(this.getRelationship("endpointDefinedBy", this.artificerArtifact, DerivedArtifactTarget.class));
            artifact.setUrl(this.getProperty("url"));
            artifact.setEnd(this.getProperty("end"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ServiceInstance artifact) {
        super.visit(artifact);
        try {
            artifact.getDescribedBy().addAll(this.getRelationships("describedBy", this.artificerArtifact, BaseArtifactTarget.class));
            artifact.getUses().addAll(this.getRelationships("uses", this.artificerArtifact, BaseArtifactTarget.class));
            artifact.setEnd(this.getProperty("end"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ServiceOperation artifact) {
        super.visit(artifact);
        try {
            artifact.setOperationDefinedBy(this.getRelationship("operationDefinedBy", this.artificerArtifact, DerivedArtifactTarget.class));
            artifact.setEnd(this.getProperty("end"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Policy artifact) {
        super.visit(artifact);
        try {
            artifact.getAppliesTo().addAll(this.getRelationships("appliesTo", this.artificerArtifact, PolicySubjectTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ServiceInterface artifact) {
        super.visit(artifact);
        try {
            artifact.setInterfaceDefinedBy(this.getRelationship("interfaceDefinedBy", this.artificerArtifact, DerivedArtifactTarget.class));
            artifact.setHasOperation(this.getRelationship("hasOperation", this.artificerArtifact, ServiceOperationTarget.class));
            artifact.getHasOutput().addAll(this.getRelationships("hasOutput", this.artificerArtifact, InformationTypeTarget.class));
            artifact.getHasInput().addAll(this.getRelationships("hasInput", this.artificerArtifact, InformationTypeTarget.class));
            artifact.getIsInterfaceOf().addAll(this.getRelationships("isInterfaceOf", this.artificerArtifact, ServiceTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ServiceContract artifact) {
        super.visit(artifact);
        try {
            artifact.getInvolvesParty().addAll(this.getRelationships("involvesParty", this.artificerArtifact, ActorTarget.class));
            artifact.getSpecifies().addAll(this.getRelationships("specifies", this.artificerArtifact, EffectTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Organization artifact) {
        super.visit(artifact);
        try {
            artifact.getProvides().addAll(this.getRelationships("provides", this.artificerArtifact, ServiceImplementationModelTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Service artifact) {
        super.visit(artifact);
        try {
            artifact.getHasContract().addAll(this.getRelationships("hasContract", this.artificerArtifact, ServiceContractTarget.class));
            artifact.getHasInterface().addAll(this.getRelationships("hasInterface", this.artificerArtifact, ServiceInterfaceTarget.class));
            artifact.setHasInstance(this.getRelationship("hasInstance", this.artificerArtifact, ServiceInstanceTarget.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getProperty(String key) {
        for (ArtificerProperty artificerProperty : this.artificerArtifact.getProperties()) {
            if (!artificerProperty.getKey().equals(key)) continue;
            return artificerProperty.getValue();
        }
        return null;
    }

    private <T> T getRelationship(ArtificerTarget artificerTarget, Class<T> targetClass) throws Exception {
        T t = this.createTarget(targetClass, artificerTarget);
        Target target = (Target)t;
        try {
            Method m = targetClass.getMethod("getArtifactType", new Class[0]);
            Class<?> mc = m.getReturnType();
            m = mc.getMethod("valueOf", String.class);
            Object o = m.invoke(null, artificerTarget.getTargetType());
            m = targetClass.getMethod("setArtifactType", o.getClass());
            m.invoke((Object)target, o);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }

    private <T> T getRelationship(String relationshipName, ArtificerArtifact artifact, Class<T> targetClass) throws Exception {
        List<T> rval = this.getRelationships(relationshipName, artifact, targetClass);
        return rval.size() == 0 ? null : (T)rval.get(0);
    }

    private <T> List<T> getRelationships(String relationshipName, ArtificerArtifact artifact, Class<T> targetClass) throws Exception {
        ArrayList<T> rval = new ArrayList<T>();
        if (this.includeAssociations) {
            for (ArtificerRelationship relationship : artifact.getRelationships()) {
                if (!relationshipName.equalsIgnoreCase(relationship.getName())) continue;
                for (ArtificerTarget artificerTarget : relationship.getTargets()) {
                    T t = this.getRelationship(artificerTarget, targetClass);
                    rval.add(t);
                }
            }
        }
        return rval;
    }

    private <T> T createTarget(Class<T> targetClass, ArtificerTarget artificerTarget) throws Exception {
        T t = targetClass.newInstance();
        Target target = (Target)t;
        if (artificerTarget != null) {
            String targetedUuid = artificerTarget.getTarget().getUuid();
            target.setValue(targetedUuid);
            String href = String.format("%1$s/%2$s/%3$s", artificerTarget.getTarget().getModel(), artificerTarget.getTarget().getType(), targetedUuid);
            target.setHref(href);
            this.setOtherAttributes(artificerTarget.getOtherAttributes(), target.getOtherAttributes());
        }
        return t;
    }
}

