/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.repository.hibernate.data;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.artificer.common.ArtificerConstants;
import org.artificer.common.query.RelationshipType;
import org.artificer.common.visitors.ArtifactVisitor;
import org.artificer.common.visitors.ArtifactVisitorHelper;
import org.artificer.common.visitors.HierarchicalArtifactVisitor;
import org.artificer.repository.hibernate.HibernateRelationshipFactory;
import org.artificer.repository.hibernate.entity.ArtificerArtifact;
import org.artificer.repository.hibernate.entity.ArtificerRelationship;
import org.artificer.repository.hibernate.entity.ArtificerTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Actor;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ActorTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Binding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Element;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Fault;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.InformationTypeTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Message;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Operation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Organization;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Part;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Policy;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PolicySubjectTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Port;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Service;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContract;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceContractTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceEndpoint;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceImplementationModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInstance;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceInterface;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ServiceOperation;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SoaModelType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.TaskTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlService;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;

public class SrampToHibernateEntityRelationshipsVisitor
extends HierarchicalArtifactVisitor {
    private final ArtificerArtifact artificerArtifact;
    private final HibernateRelationshipFactory relationshipFactory;

    public static void visit(BaseArtifactType srampArtifact, ArtificerArtifact artificerArtifact, HibernateRelationshipFactory relationshipFactory) throws Exception {
        SrampToHibernateEntityRelationshipsVisitor visitor = new SrampToHibernateEntityRelationshipsVisitor(artificerArtifact, relationshipFactory);
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)srampArtifact);
        visitor.throwError();
    }

    public SrampToHibernateEntityRelationshipsVisitor(ArtificerArtifact artificerArtifact, HibernateRelationshipFactory relationshipFactory) {
        this.artificerArtifact = artificerArtifact;
        this.relationshipFactory = relationshipFactory;
        artificerArtifact.getRelationships().clear();
    }

    protected void visitBase(BaseArtifactType artifact) {
        super.visitBase(artifact);
        try {
            if (artifact.getOtherAttributes().containsKey(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_UUID_QNAME)) {
                this.artificerArtifact.setExpandedFromArchive(true);
                this.artificerArtifact.setExpandedFromArchivePath((String)artifact.getOtherAttributes().get(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_PATH_QNAME));
                String parentUuid = (String)artifact.getOtherAttributes().get(ArtificerConstants.ARTIFICER_EXPANDED_FROM_ARCHIVE_UUID_QNAME);
                ArtificerArtifact parent = this.relationshipFactory.createRelationship(parentUuid);
                this.artificerArtifact.setExpandedFrom(parent);
                parent.getExpandedArtifacts().add(this.artificerArtifact);
            }
            this.updateGenericRelationships(artifact);
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    protected void visitWsdlDerived(WsdlDerivedArtifactType artifact) {
        super.visitWsdlDerived(artifact);
        try {
            this.setRelationships("extension", RelationshipType.DERIVED, artifact.getExtension());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    protected void visitServiceImplementation(ServiceImplementationModelType artifact) {
        super.visitServiceImplementation(artifact);
        try {
            ArrayList<String> targetTypes = new ArrayList<String>();
            for (DocumentArtifactTarget documentation : artifact.getDocumentation()) {
                targetTypes.add(documentation.getArtifactType().toString());
            }
            this.setRelationships("documentation", RelationshipType.MODELED, artifact.getDocumentation());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    protected void visitSoa(SoaModelType artifact) {
        super.visitSoa(artifact);
        try {
            ArrayList<String> targetTypes = new ArrayList<String>();
            for (DocumentArtifactTarget documentation : artifact.getDocumentation()) {
                targetTypes.add(documentation.getArtifactType().toString());
            }
            this.setRelationships("documentation", RelationshipType.MODELED, artifact.getDocumentation());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    protected void visitElement(Element artifact) {
        super.visitElement(artifact);
        try {
            ArrayList<String> targetTypes = new ArrayList<String>();
            for (ElementTarget target : artifact.getRepresents()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("represents", RelationshipType.MODELED, artifact.getRepresents());
            targetTypes = new ArrayList();
            for (ElementTarget target : artifact.getUses()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("uses", RelationshipType.MODELED, artifact.getUses());
            targetTypes = new ArrayList();
            for (ElementTarget target : artifact.getPerforms()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("performs", RelationshipType.MODELED, artifact.getPerforms());
            if (artifact.getDirectsOrchestration() != null) {
                this.setRelationship("directsOrchestration", RelationshipType.MODELED, (Target)artifact.getDirectsOrchestration());
            }
            if (artifact.getDirectsOrchestrationProcess() != null) {
                this.setRelationship("directsOrchestrationProcess", RelationshipType.MODELED, (Target)artifact.getDirectsOrchestrationProcess());
            }
            targetTypes = new ArrayList();
            for (ElementTarget target : artifact.getGenerates()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("generates", RelationshipType.MODELED, artifact.getGenerates());
            targetTypes = new ArrayList();
            for (ElementTarget target : artifact.getRespondsTo()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("respondsTo", RelationshipType.MODELED, artifact.getRespondsTo());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void visitActor(Actor artifact) {
        super.visitActor(artifact);
        try {
            ArrayList<String> targetTypes = new ArrayList<String>();
            for (TaskTarget target : artifact.getDoes()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("does", RelationshipType.MODELED, artifact.getDoes());
            targetTypes = new ArrayList();
            for (TaskTarget target : artifact.getSetsPolicy()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("setsPolicy", RelationshipType.MODELED, artifact.getSetsPolicy());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateGenericRelationships(BaseArtifactType artifact) throws Exception {
        for (Relationship relationship : artifact.getRelationship()) {
            if (relationship.getRelationshipTarget().size() <= 0) continue;
            this.setRelationships(relationship.getRelationshipType(), RelationshipType.GENERIC, relationship.getRelationshipTarget(), relationship.getOtherAttributes());
        }
    }

    public void visit(XsdDocument artifact) {
        super.visit(artifact);
        try {
            this.setRelationships("importedXsds", RelationshipType.MODELED, artifact.getImportedXsds());
            this.setRelationships("includedXsds", RelationshipType.MODELED, artifact.getIncludedXsds());
            this.setRelationships("redefinedXsds", RelationshipType.MODELED, artifact.getRedefinedXsds());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public void visit(WsdlDocument artifact) {
        super.visit(artifact);
        try {
            this.setRelationships("importedXsds", RelationshipType.MODELED, artifact.getImportedXsds());
            this.setRelationships("includedXsds", RelationshipType.MODELED, artifact.getIncludedXsds());
            this.setRelationships("redefinedXsds", RelationshipType.MODELED, artifact.getRedefinedXsds());
            this.setRelationships("importedWsdls", RelationshipType.MODELED, artifact.getImportedWsdls());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public void visit(Message artifact) {
        super.visit(artifact);
        try {
            this.setRelationships("part", RelationshipType.DERIVED, artifact.getPart());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public void visit(Part artifact) {
        super.visit(artifact);
        try {
            if (artifact.getElement() != null) {
                this.setRelationship("element", RelationshipType.DERIVED, (Target)artifact.getElement());
            } else if (artifact.getType() != null) {
                this.setRelationship("type", RelationshipType.DERIVED, (Target)artifact.getType());
            }
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public void visit(PortType artifact) {
        super.visit(artifact);
        try {
            this.setRelationships("operation", RelationshipType.DERIVED, artifact.getOperation());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public void visit(Operation artifact) {
        super.visit(artifact);
        try {
            this.setRelationship("input", RelationshipType.DERIVED, (Target)artifact.getInput());
            this.setRelationship("output", RelationshipType.DERIVED, (Target)artifact.getOutput());
            this.setRelationships("fault", RelationshipType.DERIVED, artifact.getFault());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public void visit(OperationInput artifact) {
        super.visit(artifact);
        try {
            this.setRelationship("message", RelationshipType.DERIVED, (Target)artifact.getMessage());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public void visit(OperationOutput artifact) {
        super.visit(artifact);
        try {
            this.setRelationship("message", RelationshipType.DERIVED, (Target)artifact.getMessage());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public void visit(Fault artifact) {
        super.visit(artifact);
        try {
            this.setRelationship("message", RelationshipType.DERIVED, (Target)artifact.getMessage());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public void visit(Binding artifact) {
        super.visit(artifact);
        try {
            this.setRelationships("bindingOperation", RelationshipType.DERIVED, artifact.getBindingOperation());
            this.setRelationship("portType", RelationshipType.DERIVED, (Target)artifact.getPortType());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(BindingOperation artifact) {
        super.visit(artifact);
        try {
            this.setRelationship("input", RelationshipType.DERIVED, (Target)artifact.getInput());
            this.setRelationship("output", RelationshipType.DERIVED, (Target)artifact.getOutput());
            this.setRelationships("fault", RelationshipType.DERIVED, artifact.getFault());
            this.setRelationship("operation", RelationshipType.DERIVED, (Target)artifact.getOperation());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(WsdlService artifact) {
        super.visit(artifact);
        try {
            this.setRelationships("port", RelationshipType.DERIVED, artifact.getPort());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Port artifact) {
        super.visit(artifact);
        try {
            this.setRelationship("binding", RelationshipType.DERIVED, (Target)artifact.getBinding());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ServiceEndpoint artifact) {
        super.visit(artifact);
        try {
            if (artifact.getEndpointDefinedBy() != null) {
                this.setRelationship("endpointDefinedBy", RelationshipType.MODELED, (Target)artifact.getEndpointDefinedBy());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ServiceInstance artifact) {
        super.visit(artifact);
        try {
            ArrayList<String> targetTypes = new ArrayList<String>();
            for (BaseArtifactTarget target : artifact.getUses()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("uses", RelationshipType.MODELED, artifact.getUses());
            targetTypes = new ArrayList();
            for (BaseArtifactTarget target : artifact.getDescribedBy()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("describedBy", RelationshipType.MODELED, artifact.getDescribedBy());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ServiceOperation artifact) {
        super.visit(artifact);
        try {
            if (artifact.getOperationDefinedBy() != null) {
                this.setRelationship("operationDefinedBy", RelationshipType.MODELED, (Target)artifact.getOperationDefinedBy());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Policy artifact) {
        super.visit(artifact);
        try {
            ArrayList<String> targetTypes = new ArrayList<String>();
            for (PolicySubjectTarget target : artifact.getAppliesTo()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("appliesTo", RelationshipType.MODELED, artifact.getAppliesTo());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ServiceInterface artifact) {
        super.visit(artifact);
        try {
            if (artifact.getInterfaceDefinedBy() != null) {
                this.setRelationship("interfaceDefinedBy", RelationshipType.MODELED, (Target)artifact.getInterfaceDefinedBy());
            }
            if (artifact.getHasOperation() != null) {
                this.setRelationship("hasOperation", RelationshipType.MODELED, (Target)artifact.getHasOperation());
            }
            ArrayList<String> targetTypes = new ArrayList<String>();
            for (InformationTypeTarget target : artifact.getHasOutput()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("hasOutput", RelationshipType.MODELED, artifact.getHasOutput());
            targetTypes = new ArrayList();
            for (InformationTypeTarget target : artifact.getHasInput()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("hasInput", RelationshipType.MODELED, artifact.getHasInput());
            targetTypes = new ArrayList();
            for (InformationTypeTarget target : artifact.getIsInterfaceOf()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("isInterfaceOf", RelationshipType.MODELED, artifact.getIsInterfaceOf());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(ServiceContract artifact) {
        super.visit(artifact);
        try {
            ArrayList<String> targetTypes = new ArrayList<String>();
            for (ActorTarget target : artifact.getInvolvesParty()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("involvesParty", RelationshipType.MODELED, artifact.getInvolvesParty());
            targetTypes = new ArrayList();
            for (ActorTarget target : artifact.getSpecifies()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("specifies", RelationshipType.MODELED, artifact.getSpecifies());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Organization artifact) {
        super.visit(artifact);
        try {
            ArrayList<String> targetTypes = new ArrayList<String>();
            for (ServiceImplementationModelTarget target : artifact.getProvides()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("provides", RelationshipType.MODELED, artifact.getProvides());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(Service artifact) {
        super.visit(artifact);
        try {
            ArrayList<String> targetTypes = new ArrayList<String>();
            for (ServiceContractTarget target : artifact.getHasContract()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("hasContract", RelationshipType.MODELED, artifact.getHasContract());
            targetTypes = new ArrayList();
            for (ServiceContractTarget target : artifact.getHasInterface()) {
                targetTypes.add(target.getArtifactType().toString());
            }
            this.setRelationships("hasInterface", RelationshipType.MODELED, artifact.getHasInterface());
            if (artifact.getHasInstance() != null) {
                this.setRelationship("hasInstance", RelationshipType.MODELED, (Target)artifact.getHasInstance());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setRelationship(String relationshipName, RelationshipType relationshipType, Target target) throws Exception {
        if (target != null && StringUtils.isNotBlank((String)target.getValue())) {
            ArtificerRelationship artificerRelationship = this.createRelationship(relationshipName, relationshipType, Collections.EMPTY_MAP);
            this.createTarget(artificerRelationship, target);
            this.artificerArtifact.getRelationships().add(artificerRelationship);
        }
    }

    private void setRelationships(String relationshipName, RelationshipType relationshipType, List<? extends Target> targets, Map<QName, String> relationshipOtherAttributes) throws Exception {
        if (targets.size() > 0) {
            ArtificerRelationship artificerRelationship = this.createRelationship(relationshipName, relationshipType, relationshipOtherAttributes);
            for (Target target : targets) {
                if (!StringUtils.isNotBlank((String)target.getValue())) continue;
                this.createTarget(artificerRelationship, target);
            }
            if (!artificerRelationship.getTargets().isEmpty()) {
                this.artificerArtifact.getRelationships().add(artificerRelationship);
            }
        }
    }

    private void setRelationships(String relationshipName, RelationshipType relationshipType, List<? extends Target> targets) throws Exception {
        this.setRelationships(relationshipName, relationshipType, targets, Collections.EMPTY_MAP);
    }

    private ArtificerRelationship createRelationship(String relationshipName, RelationshipType relationshipType, Map<QName, String> relationshipOtherAttributes) throws Exception {
        ArtificerRelationship artificerRelationship = new ArtificerRelationship();
        artificerRelationship.setName(relationshipName);
        artificerRelationship.setType(relationshipType);
        artificerRelationship.setOwner(this.artificerArtifact);
        for (QName key : relationshipOtherAttributes.keySet()) {
            String value = relationshipOtherAttributes.get(key);
            artificerRelationship.getOtherAttributes().put(key.toString(), value);
        }
        return artificerRelationship;
    }

    private void createTarget(ArtificerRelationship artificerRelationship, Target target) throws Exception {
        ArtificerTarget artificerTarget = new ArtificerTarget();
        artificerTarget.setTarget(this.relationshipFactory.createRelationship(target.getValue()));
        try {
            Method m = target.getClass().getMethod("getArtifactType", new Class[0]);
            Object o = m.invoke((Object)target, new Object[0]);
            m = o.getClass().getMethod("name", new Class[0]);
            String targetType = (String)m.invoke(o, new Object[0]);
            artificerTarget.setTargetType(targetType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        artificerTarget.setRelationship(artificerRelationship);
        for (QName key : target.getOtherAttributes().keySet()) {
            String value = (String)target.getOtherAttributes().get(key);
            artificerTarget.getOtherAttributes().put(key.toString(), value);
        }
        artificerRelationship.getTargets().add(artificerTarget);
    }
}

